/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.utils;

import com.lpro.iot.common.Config;
import com.lpro.iot.utils.ObjectUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceSender {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HttpServiceSender.class);
    protected static final int SC_OK = 200;
    protected static final int SC_REDIRECT = 403;
    protected static final int SC_UNRESOURCE = 404;
    protected static final int SC_SERVER_ERROE = 500;
    protected static final int SC_ERROR_REQUEST = 503;
    static String body = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] doGet(String url, String userKey) {
        String[] response = new String[2];
        response[0] = "-1";
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(2000);
        client.getHttpConnectionManager().getParams().setSoTimeout(2000);
        GetMethod getMethod = new GetMethod(url);
        getMethod.getParams().setParameter("http.protocol.content-charset", "utf-8");
        getMethod.setRequestHeader("Content-Type", "application/json");
        if (ObjectUtil.isNotEmpty(userKey).booleanValue()) {
            getMethod.setRequestHeader("USER-KEY", userKey);
        }
        try {
            client.executeMethod(getMethod);
            response[0] = String.valueOf(getMethod.getStatusCode());
            if (getMethod.getStatusCode() == 200) {
                InputStream inputStream = getMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    stringBuffer.append(str);
                }
                response[1] = stringBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            getMethod.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] doPost(String url, String userKey, String bodyString) {
        String[] response = new String[2];
        response[0] = "-1";
        HttpClient client = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setParameter("http.protocol.content-charset", "utf-8");
        postMethod.setRequestHeader("Content-Type", "application/json");
        if (ObjectUtil.isNotEmpty(userKey).booleanValue()) {
            postMethod.setRequestHeader("Authorization", userKey);
            postMethod.setRequestHeader("USER-KEY", userKey);
        }
        postMethod.setRequestBody(bodyString);
        try {
            client.executeMethod(postMethod);
            if (postMethod.getStatusCode() == 200) {
                response[0] = "200";
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    stringBuffer.append(str);
                }
                response[1] = stringBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            postMethod.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] doPut(String url, String userKey, String bodyString) {
        String[] response = new String[2];
        response[0] = "-1";
        HttpClient client = new HttpClient();
        PutMethod putMethod = new PutMethod(url);
        putMethod.getParams().setParameter("http.protocol.content-charset", "utf-8");
        putMethod.setRequestHeader("Content-Type", "application/json");
        if (ObjectUtil.isNotEmpty(userKey).booleanValue()) {
            putMethod.setRequestHeader("USER-KEY", userKey);
            putMethod.setRequestHeader("CLIENT-KEY", Config.IOT_LPM_KEY);
        }
        putMethod.setRequestBody(bodyString);
        try {
            client.executeMethod(putMethod);
            if (putMethod.getStatusCode() == 200) {
                InputStream inputStream = putMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    stringBuffer.append(str);
                }
                response[1] = stringBuffer.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            putMethod.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] doDelete(String url) {
        String[] response = new String[2];
        response[0] = "-1";
        HttpClient client = new HttpClient();
        DeleteMethod deleteMethod = new DeleteMethod(url);
        deleteMethod.setRequestHeader("Content-Type", "application/json");
        try {
            client.executeMethod(deleteMethod);
            response[0] = String.valueOf(deleteMethod.getStatusCode());
            if (deleteMethod.getStatusCode() == 200) {
                InputStream inputStream = deleteMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    stringBuffer.append(str);
                }
                response[1] = stringBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            deleteMethod.releaseConnection();
        }
        return response;
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        String start = "2012-02-01";
        String end = "2012-03-02";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date dBegin = sdf.parse(start);
            Date dEnd = sdf.parse(end);
            List<Date> lDate = HttpServiceSender.findDates(dBegin, dEnd);
            for (Date date2 : lDate) {
                System.out.println(sdf.format(date2));
                System.out.println(date2);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static String getSpecifiedDayAfter(String specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date2 = null;
        try {
            date2 = new SimpleDateFormat("yy-MM-dd").parse(specifiedDay);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date2);
        int day = c.get(5);
        c.set(5, day + 1);
        String dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayAfter;
    }
}

