/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.server;

import com.lpro.iot.server.ServerIoHandler;
import com.lpro.iot.utils.Util;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpSeverHandler
extends IoHandlerAdapter {
    private static Logger logger = LoggerFactory.getLogger(UdpSeverHandler.class);
    public static final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        logger.error("[IMCORE]exceptionCaught\u6355\u83b7\u5230\u9519\u4e86\uff0c\u539f\u56e0\u662f\uff1a" + cause.getMessage(), cause);
        session.close(true);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer ioBuffer = (IoBuffer)message;
        byte[] data = new byte[ioBuffer.limit()];
        ioBuffer.get(data);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            stringBuffer.append((char)data[i]);
        }
        ServerIoHandler.LOGGER.info("udp orgin byte data: " + Util.binhexoct.bytesToHex(data));
        ServerIoHandler.LOGGER.info("udp orgin String data:" + stringBuffer.toString());
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        String ip = session.getRemoteAddress().toString().split("\\:")[0];
        logger.info(ip + " connection is open!");
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        logger.info("session is closed!");
    }
}

