/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.protocal.impl;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.bean.IotNodeInfo;
import com.lpro.iot.bean.IotNodeInfoBO;
import com.lpro.iot.bean.IotSensorInfo;
import com.lpro.iot.bean.IotSensorInfoBO;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Cache;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.common.Constants;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.protocal.Iprotocal;
import com.lpro.iot.server.MinaServer;
import com.lpro.iot.utils.HttpServiceSender;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocalYw
implements Iprotocal {
    public static final Logger LOGGER = LoggerFactory.getLogger(ProtocalYw.class);

    public static void main(String[] args) {
        String address = "1";
        byte[] command = new byte[]{119, 7};
        command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Integer.parseInt(address), 4));
        command = Util.protocal.append(command, new byte[]{4});
        byte a = 0;
        for (int i = 1; i < command.length; ++i) {
            a = (byte)(a + command[i]);
        }
        command = Util.protocal.append(command, new byte[]{a});
        System.out.println(command);
    }

    @Override
    public void loginProtocal(IoSession session, byte[] data, String msg, ReturnObj obj) {
        String deviceCode = null;
        deviceCode = msg;
        if (obj == null) {
            if (msg.length() > 60) {
                return;
            }
            obj = Util.NodeDevice.login(deviceCode);
        }
        if (obj.getStatus() == Code.ResponseCode.OK + 0) {
            session.setAttribute("deviceId", deviceCode);
            session.setAttribute("nodeInfo", obj.getData());
            session.setAttribute("dataCache", "");
            session.setAttribute("ProtocolCategory", this.getClass().getSimpleName());
            if (Cache.nodeIdsessionMap.containsKey(deviceCode)) {
                Cache.nodeIdsessionMap.get(deviceCode).removeAttribute("deviceId");
                Cache.nodeIdsessionMap.get(deviceCode).close(true);
            }
            Cache.nodeIdsessionMap.put(deviceCode, session);
            Thread t = new Thread(new TimerTaskThread(obj.getData()));
            t.start();
            session.setAttribute("threadHashCode", t.hashCode());
        }
    }

    @Override
    public void analysisData(IoSession session, byte[] data, String msg) {
        Object deviceCode = session.getAttribute("deviceId");
        if (Cache.deviceMap.containsKey(deviceCode)) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("askii", msg);
            map2.put("byte", Util.binhexoct.bytesToHex(data));
            MqttService.pubMessage(JSON.toJSONString(map2), "/sys/debug/" + deviceCode);
        }
        LOGGER.info("Lora YW \u6570\u636e=" + msg);
        try {
            if (119 == Util.protocal.getOtcFromByte(data[0])) {
                int lenght = Util.protocal.getOtcFromByte(data[1]);
                if (lenght + 1 == data.length || data.length % (lenght + 1) == 0) {
                    String address = Util.protocal.getOctFromHexBytes(data, 2, 5);
                    int i = 7;
                    float x = (float)((data[i] == 0 ? 1 : -1) * Integer.parseInt(Util.protocal.getHexFromByte(data[i + 1]) + "" + Util.protocal.getHexFromByte(data[i + 2]) + Util.protocal.getHexFromByte(data[i + 3]))) / 10000.0f;
                    i = 11;
                    float y = (float)((data[i] == 0 ? 1 : -1) * Integer.parseInt(Util.protocal.getHexFromByte(data[i + 1]) + "" + Util.protocal.getHexFromByte(data[i + 2]) + Util.protocal.getHexFromByte(data[i + 3]))) / 10000.0f;
                    i = 15;
                    float tempure = (float)((data[i] == 0 ? 1 : -1) * Integer.parseInt(Util.protocal.getHexFromByte(data[i + 1]) + "" + Util.protocal.getHexFromByte(data[i + 2]))) / 100.0f;
                    float battery = (float)Integer.parseInt(Util.protocal.getHexFromByte(data[18])) + 0.0f;
                    final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                    list.add(new IotSensorInfo(address, (Integer)0, Float.valueOf(x), deviceCode.toString()));
                    list.add(new IotSensorInfo(address, (Integer)1, Float.valueOf(y), deviceCode.toString()));
                    list.add(new IotSensorInfo(address, (Integer)2, Float.valueOf(tempure), deviceCode.toString()));
                    list.add(new IotSensorInfo(address, (Integer)3, Float.valueOf(battery), deviceCode.toString()));
                    MinaServer.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String body = Util.json.object2Json(list);
                            String url = Constants.URL.SENSORS_DATA;
                            HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                        }
                    });
                } else {
                    LOGGER.info("Lora YW \u6570\u636e\u4e0d\u5b8c\u6574\uff0clength=" + lenght + ", datalength=" + data.length);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handbert(IoSession session) {
        try {
            if (session.containsAttribute("nodeInfo")) {
                IotNodeInfoBO nodeBO = (IotNodeInfoBO)session.getAttribute("nodeInfo");
                if (nodeBO.getFrequency() < 1) {
                    return;
                }
                if (session.getLastReadTime() + (long)((nodeBO.getFrequency() + 60) * 1000) < new Date().getTime()) {
                    session.close(true);
                    return;
                }
            } else {
                session.close(true);
            }
        }
        catch (Exception e) {
            session.close(true);
        }
    }

    @Override
    public void execServer(IoSession session, byte[] data, String msg) {
        String subStr = msg.split(":")[1];
        String[] commands = subStr.split(",");
        String type = commands[0];
        String nodeDeviceCode = commands[1];
        String address = commands[2];
        String subType = commands[3];
        byte btype = Byte.parseByte(subType);
        byte[] command = new byte[]{119, 8};
        command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Integer.parseInt(address), 4));
        command = Util.protocal.append(command, new byte[]{5, btype});
        byte a = 0;
        for (int i = 1; i < command.length; ++i) {
            a = (byte)(a + command[i]);
        }
        command = Util.protocal.append(command, new byte[]{a});
        Util.mina.write(Cache.nodeIdsessionMap.get(nodeDeviceCode), command);
    }

    @Override
    public boolean match(IoSession session, byte[] data, String msg) {
        return false;
    }

    @Override
    public void logout(IoSession session) {
        IotNodeInfo iotNodeInfo = new IotNodeInfo();
        iotNodeInfo.setDevice_code(session.getAttribute("deviceId") + "");
        iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.offline);
        iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
        String body = Util.json.object2Json(iotNodeInfo);
        HttpServiceSender.doPut(Constants.URL.NODE_INFO, Config.IOT_USER_KEY, body);
    }

    public class TimerTaskThread
    implements Runnable {
        private IotNodeInfoBO nodeInfo;

        public TimerTaskThread(IotNodeInfoBO nodeInfo) {
            this.nodeInfo = nodeInfo;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (ObjectUtil.isNotEmpty(this.nodeInfo).booleanValue()) {
                        Integer period = this.nodeInfo.getFrequency();
                        if (period != null && period < 2) {
                            period = 2;
                        }
                        Thread.sleep(period * 1000);
                        IoSession session = Cache.nodeIdsessionMap.get(this.nodeInfo.getDevice_code());
                        if (ObjectUtil.isEmpty(session).booleanValue()) {
                            return;
                        }
                        Integer hashCode = (Integer)session.getAttribute("threadHashCode");
                        if (hashCode + 0 != this.hashCode()) {
                            return;
                        }
                        List<IotSensorInfoBO> sensorList = ((IotNodeInfoBO)session.getAttribute("nodeInfo")).getIotSensorList();
                        HashSet<String> addressSet = new HashSet<String>();
                        for (IotSensorInfoBO tmp : sensorList) {
                            if (addressSet.contains(tmp.getSensor_device_id())) continue;
                            addressSet.add(tmp.getSensor_device_id());
                            String address = tmp.getSensor_device_id();
                            byte[] command = new byte[]{119, 7};
                            command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Integer.parseInt(address), 4));
                            command = Util.protocal.append(command, new byte[]{4});
                            byte a = 0;
                            for (int i = 1; i < command.length; ++i) {
                                a = (byte)(a + command[i]);
                            }
                            command = Util.protocal.append(command, new byte[]{a});
                            Util.mina.write(session, command);
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

