/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.protocal.impl;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.bean.IotNodeInfo;
import com.lpro.iot.bean.IotNodeInfoBO;
import com.lpro.iot.bean.IotSensorInfo;
import com.lpro.iot.bean.IotSensorInfoBO;
import com.lpro.iot.bean.LockResult;
import com.lpro.iot.bean.ModbusConfig;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Cache;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.common.Constants;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.protocal.Iprotocal;
import com.lpro.iot.server.MinaServer;
import com.lpro.iot.utils.CoordinateTransformUtil;
import com.lpro.iot.utils.HttpServiceSender;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.mina.core.session.IoSession;

public class ProtocalModbusTcp
extends TimerTask
implements Iprotocal {
    public static final Integer repeatTimes = 1;
    public static final Integer timeOut = 5000;
    private static final String realDataLock = "REAL_DATA";
    private static final String realData = "DATA";
    private static final String nodeSensorsInfo = "NODE_SENSORS_INFO";
    private IotNodeInfoBO nodeInfo;

    public static void main(String[] args) {
    }

    @Override
    public void loginProtocal(IoSession session, byte[] data, String msg, ReturnObj obj) {
        if (data.length > 100) {
            return;
        }
        String deviceCode = msg;
        if (obj == null) {
            obj = Util.NodeDevice.loginReturn(deviceCode);
        }
        if (obj.getStatus() == Code.ResponseCode.OK + 0 && ObjectUtil.isNotEmpty(obj.getData()).booleanValue()) {
            session.setAttribute("deviceId", deviceCode);
            session.setAttribute("ProtocolCategory", this.getClass().getSimpleName());
            LockResult lockResult = new LockResult();
            lockResult.setFlag(false);
            session.setAttribute(realDataLock, lockResult);
            session.setAttribute(nodeSensorsInfo, obj.getData());
            if (Cache.nodeIdsessionMap.containsKey(deviceCode)) {
                try {
                    Cache.nodeIdsessionMap.get(deviceCode).close(true);
                    if (Cache.timerTaskMap.containsKey(deviceCode)) {
                        Timer timeTask = Cache.timerTaskMap.get(deviceCode);
                        if (ObjectUtil.isNotEmpty(timeTask).booleanValue()) {
                            timeTask.cancel();
                            timeTask = null;
                        }
                        Cache.timerTaskMap.remove(deviceCode);
                    }
                    session.close(true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    session.close(true);
                    return;
                }
            }
            Cache.nodeIdsessionMap.put(deviceCode, session);
            Timer timeTask = new Timer();
            Integer frequency = obj.getData().getFrequency();
            if (frequency != null && frequency + 0 > 0) {
                timeTask.schedule((TimerTask)new ProtocalModbusTcp(obj.getData()), new Date(), (long)(frequency * 1000));
            } else {
                timeTask.schedule((TimerTask)new ProtocalModbusTcp(obj.getData()), new Date(), 3000L);
            }
            Cache.timerTaskMap.put(deviceCode, timeTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analysisData(IoSession session, byte[] data, String msg) {
        LockResult lockResult;
        Object deviceCode = session.getAttribute("deviceId");
        if (Cache.deviceMap.containsKey(deviceCode)) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("askii", msg);
            map2.put("byte", Util.binhexoct.bytesToHex(data));
            map2.put("direction", "2");
            map2.put("time", new Date().getTime() + "");
            MqttService.pubMessage(JSON.toJSONString(map2), "/sys/debug/" + deviceCode);
        }
        if (!ObjectUtil.isNotEmpty(data).booleanValue() || data.length <= 9 || data[2] != 0 || data[3] != 0 || data[5] + 6 != data.length) {
            return;
        }
        LockResult lockResult2 = lockResult = (LockResult)session.getAttribute(realDataLock);
        synchronized (lockResult2) {
            lockResult = (LockResult)session.getAttribute(realDataLock);
            session.setAttribute(realData, data);
            lockResult.setFlag(false);
            lockResult.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execServer(IoSession session, byte[] data, String msg) {
        block20: {
            String subStr = msg.split(":")[1];
            String[] commands = subStr.split(",");
            String type = commands[0];
            String deviceCode = (String)session.getAttribute("deviceId");
            if (ObjectUtil.isNotEmpty(session.getAttribute("deviceFlag")).booleanValue()) {
                return;
            }
            if ("control".equalsIgnoreCase(type) || "param_write".equalsIgnoreCase(type)) {
                Integer sensorDeviceId = Integer.parseInt(commands[2]);
                Integer portId = Integer.parseInt(commands[3]);
                Float datas = Float.valueOf(Float.parseFloat(commands[4]));
                int aa = msg.trim().indexOf(123);
                ModbusConfig modbus = null;
                if (aa > -1) {
                    modbus = (ModbusConfig)JSON.parseObject((String)msg.trim().substring(aa), ModbusConfig.class);
                }
                int vseq = (int)Math.random() * 1000;
                byte[] seqs = Util.protocal.octInt2ByteArray(vseq, 2);
                byte[] command = new byte[]{0, 0, 0, 0, 0, 6, 1, 6};
                command[0] = seqs[0];
                command[1] = seqs[1];
                if (ObjectUtil.isNotEmpty(modbus.getFcode()).booleanValue()) {
                    if ("06".equals(modbus.getFcode()) || "03".equals(modbus.getFcode())) {
                        command[7] = 6;
                    } else if ("05".equals(modbus.getFcode()) || "01".equals(modbus.getFcode())) {
                        command[7] = 5;
                    }
                }
                command[6] = (byte)Integer.parseInt(sensorDeviceId + "");
                Byte.parseByte(sensorDeviceId + "");
                command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(this.whole2simple(portId), 2));
                if (datas.floatValue() == 1.0f && command[7] == 5) {
                    datas = Float.valueOf(65280.0f);
                }
                command = Util.protocal.append(command, Util.protocal.octInt2ByteArray((int)(datas.floatValue() + 0.0f), 2));
                try {
                    Object map2;
                    LockResult lockResult = (LockResult)session.getAttribute(realDataLock);
                    int sleepCount = 0;
                    while (lockResult.getFlag().booleanValue()) {
                        Thread.sleep(48L);
                        if (sleepCount++ <= 46) continue;
                        return;
                    }
                    if (Cache.deviceMap.containsKey(deviceCode)) {
                        map2 = new HashMap();
                        map2.put("askii", msg);
                        map2.put("byte", Util.binhexoct.bytesToHex(data));
                        map2.put("direction", "1");
                        map2.put("time", new Date().getTime() + "");
                        MqttService.pubMessage(JSON.toJSONString((Object)map2), "/sys/debug/" + deviceCode);
                    }
                    map2 = lockResult;
                    synchronized (map2) {
                        lockResult = (LockResult)session.getAttribute(realDataLock);
                        lockResult.setFlag(true);
                        int i = repeatTimes;
                        while (i-- > 0) {
                            Util.mina.write(session, command);
                            lockResult.wait(timeOut.intValue());
                            if (lockResult.getFlag().booleanValue()) continue;
                        }
                    }
                    if (!lockResult.getFlag().booleanValue()) {
                        byte[] datab = (byte[])session.getAttribute(realData);
                        int respVisitorSeq = Integer.parseInt(Util.protocal.getOctFromHexBytes(datab, 0, 1));
                        if (respVisitorSeq == vseq) {
                            final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                            int rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(datab, 10, 11));
                            if (datab[7] == 5 && rh == 65280) {
                                rh = 1;
                            }
                            list.add(new IotSensorInfo(datab[6] + "", portId, Float.valueOf((float)rh + 0.0f), deviceCode));
                            MinaServer.threadPool.execute(new Runnable(){

                                @Override
                                public void run() {
                                    String body = Util.json.object2Json(list);
                                    String url = Constants.URL.SENSORS_DATA;
                                    HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                                }
                            });
                        }
                    } else {
                        lockResult.setFlag(false);
                    }
                }
                catch (Exception e) {
                    if (!ObjectUtil.isNotEmpty(session).booleanValue()) break block20;
                    session.close(true);
                }
            }
        }
    }

    @Override
    public void handbert(IoSession session) {
        try {
            if (session.containsAttribute(nodeSensorsInfo)) {
                IotNodeInfoBO nodeBO = (IotNodeInfoBO)session.getAttribute(nodeSensorsInfo);
                if (nodeBO.getFrequency() < 4) {
                    return;
                }
                if (session.getLastReadTime() + 1200000L < new Date().getTime()) {
                    session.close(true);
                    return;
                }
            } else {
                session.close(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProtocalModbusTcp() {
    }

    public ProtocalModbusTcp(IotNodeInfoBO nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block54: {
            IoSession session = Cache.nodeIdsessionMap.get(this.nodeInfo.getDevice_code());
            try {
                if (ObjectUtil.isNotEmpty(session).booleanValue()) {
                    String deviceCode = this.nodeInfo.getDevice_code();
                    this.nodeInfo = (IotNodeInfoBO)session.getAttribute(nodeSensorsInfo);
                    if (ObjectUtil.isNotEmpty(this.nodeInfo.getInfos()).booleanValue() && this.nodeInfo.getInfos().contains("fcode")) {
                        List sensorConfigs = JSON.parseArray((String)this.nodeInfo.getInfos(), ModbusConfig.class);
                        int vseq = (int)Math.random() * 1000;
                        for (ModbusConfig sensorConfig : sensorConfigs) {
                            byte[] seqs = Util.protocal.octInt2ByteArray(++vseq, 2);
                            byte[] command = new byte[]{0, 0, 0, 0, 0, 6, 1, 3};
                            command[0] = seqs[0];
                            command[1] = seqs[1];
                            command[6] = (byte)Integer.parseInt(sensorConfig.getAddress() + "");
                            Byte.parseByte(sensorConfig.getAddress() + "");
                            command[7] = "01".equals(sensorConfig.getFcode()) ? 1 : ("04".equals(sensorConfig.getFcode()) ? 4 : ("02".equals(sensorConfig.getFcode()) ? 2 : 3));
                            int saddrparam = Integer.parseInt(sensorConfig.getSaddr());
                            int lengthparam = Integer.parseInt(sensorConfig.getLength());
                            int fcode = Integer.parseInt(sensorConfig.getFcode());
                            command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(saddrparam, 2));
                            command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(lengthparam, 2));
                            if (ObjectUtil.isNotEmpty(session.getAttribute("deviceFlag")).booleanValue()) continue;
                            if (Cache.deviceMap.containsKey(deviceCode)) {
                                HashMap<String, String> map2 = new HashMap<String, String>();
                                map2.put("askii", Util.binhexoct.bytesToHex(command));
                                map2.put("byte", Util.binhexoct.bytesToHex(command));
                                map2.put("direction", "1");
                                map2.put("time", new Date().getTime() + "");
                                MqttService.pubMessage(JSON.toJSONString(map2), "/sys/debug/" + deviceCode);
                            }
                            LockResult lockResult3 = (LockResult)session.getAttribute(realDataLock);
                            int sleepCount = 0;
                            while (lockResult3.getFlag().booleanValue()) {
                                Thread.sleep(100L);
                                if (sleepCount++ <= 20) continue;
                                return;
                            }
                            LockResult lockResult2 = lockResult3;
                            synchronized (lockResult2) {
                                lockResult3 = (LockResult)session.getAttribute(realDataLock);
                                lockResult3.setFlag(true);
                                int i = repeatTimes;
                                while (i-- > 0) {
                                    Util.mina.write(session, command);
                                    lockResult3.wait(timeOut.intValue());
                                    if (lockResult3.getFlag().booleanValue()) continue;
                                }
                            }
                            if (!lockResult3.getFlag().booleanValue()) {
                                byte[] data = (byte[])session.getAttribute(realData);
                                int respVisitorSeq = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 0, 1));
                                if (respVisitorSeq == vseq) {
                                    final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                                    List<IotSensorInfoBO> sensorList = ((IotNodeInfoBO)session.getAttribute(nodeSensorsInfo)).getIotSensorList();
                                    if (fcode == 1 || fcode == 2 || fcode == 5) {
                                        int returnDataLength = data[8];
                                        for (int k = 0; k < returnDataLength; ++k) {
                                            block12: for (int m = 0; m < 8; ++m) {
                                                for (int i = 0; i < sensorList.size(); ++i) {
                                                    String sensorDeviceId = sensorList.get(i).getSensor_device_id();
                                                    Integer sensorPortId = sensorList.get(i).getPort_id();
                                                    if (!sensorDeviceId.equals(data[6] + 0 + "") || this.simple2whole(saddrparam + k * 8 + m, fcode) + 0 != sensorPortId) continue;
                                                    list.add(new IotSensorInfo(data[6] + 0 + "", this.simple2whole(saddrparam + k * 8 + m, fcode), data[9 + k] >> m & 1, deviceCode));
                                                    continue block12;
                                                }
                                            }
                                        }
                                    } else if (data[9] == 36) {
                                        StringBuffer stringBuffer = new StringBuffer();
                                        for (int i = 0; i < data.length; ++i) {
                                            stringBuffer.append((char)data[i]);
                                        }
                                        String msg = stringBuffer.toString();
                                        String gpsdata = msg.substring(9, 79);
                                        String[] subval = gpsdata.split(",");
                                        if (subval.length > 0) {
                                            String lon = subval[3];
                                            String lat = subval[5];
                                            Float latf = Float.valueOf((float)Integer.parseInt(lat.substring(0, 3)) + Float.parseFloat(lat.substring(3)) / 60.0f);
                                            Float lonf = Float.valueOf((float)Integer.parseInt(lon.substring(0, 2)) + Float.parseFloat(lon.substring(2)) / 60.0f);
                                            String lonlat = latf + "," + lonf;
                                            list.add(new IotSensorInfo(data[6] + "", this.simple2whole(saddrparam, fcode), CoordinateTransformUtil.strwgs2bd(lonlat), deviceCode));
                                        }
                                    } else {
                                        for (int i = 0; i < sensorList.size(); ++i) {
                                            int rh;
                                            ModbusConfig modbus;
                                            int sensorDeviceId = Integer.parseInt(sensorList.get(i).getSensor_device_id());
                                            if (sensorDeviceId != data[6]) continue;
                                            if (ObjectUtil.isEmpty(sensorList.get(i).getInfos()).booleanValue()) {
                                                sensorList.get(i).setInfos("{}");
                                            }
                                            if (ObjectUtil.isEmpty(modbus = (ModbusConfig)JSON.parseObject((String)sensorList.get(i).getInfos(), ModbusConfig.class)).booleanValue()) {
                                                modbus = new ModbusConfig();
                                            }
                                            int simpleaddress = this.whole2simple(sensorList.get(i).getPort_id());
                                            if ("float".equals(modbus.getType())) {
                                                if (simpleaddress < saddrparam || 9 + (simpleaddress - saddrparam) * 2 + 4 > data.length) continue;
                                                float rh2 = -1.0f;
                                                rh2 = "CDAB".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getFloat3412(data, 9 + (simpleaddress - saddrparam) * 2) : ("DCBA".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getFloat4321(data, 9 + (simpleaddress - saddrparam) * 2) : ("BADC".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getFloat2143(data, 9 + (simpleaddress - saddrparam) * 2) : Util.ByteArrayConveter.getFloat(data, 9 + (simpleaddress - saddrparam) * 2)));
                                                list.add(new IotSensorInfo(sensorList.get(i).getSensor_device_id(), sensorList.get(i).getPort_id(), Float.valueOf(rh2 + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if ("int".equals(modbus.getType())) {
                                                if (simpleaddress < saddrparam || 9 + (simpleaddress - saddrparam) * 2 > data.length - 2) continue;
                                                Integer start = 9 + (simpleaddress - saddrparam) * 2;
                                                rh = 0;
                                                rh = "CDAB".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt3412(data, start) : ("DCBA".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt4321(data, start) : ("BADC".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt2143(data, start) : Util.ByteArrayConveter.getInt(data, start)));
                                                if (rh > 2047) {
                                                    rh -= 65536;
                                                }
                                                list.add(new IotSensorInfo(sensorList.get(i).getSensor_device_id(), sensorList.get(i).getPort_id(), Float.valueOf((float)rh + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if ("uint32".equals(modbus.getType())) {
                                                if (simpleaddress < saddrparam || 9 + (simpleaddress - saddrparam) * 2 > data.length - 4) continue;
                                                Integer start = 9 + (simpleaddress - saddrparam) * 2;
                                                rh = 0;
                                                rh = "CDAB".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt3412(data, start) : ("DCBA".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt4321(data, start) : ("BADC".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt2143(data, start) : Util.ByteArrayConveter.getInt(data, start)));
                                                list.add(new IotSensorInfo(sensorList.get(i).getSensor_device_id(), sensorList.get(i).getPort_id(), Float.valueOf((float)rh + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if ("int32".equals(modbus.getType())) {
                                                if (simpleaddress < saddrparam || 9 + (simpleaddress - saddrparam) * 2 > data.length - 4) continue;
                                                Integer start = 9 + (simpleaddress - saddrparam) * 2;
                                                rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, start, start + 3));
                                                if (rh > Integer.MAX_VALUE) {
                                                    long srh = (long)rh - 0x100000000L;
                                                    rh = (int)srh;
                                                }
                                                list.add(new IotSensorInfo(sensorList.get(i).getSensor_device_id(), sensorList.get(i).getPort_id(), Float.valueOf((float)rh + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if (simpleaddress < saddrparam || 9 + (simpleaddress - saddrparam) * 2 > data.length - 2) continue;
                                            Integer start = 9 + (simpleaddress - saddrparam) * 2;
                                            rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, start, start + 1));
                                            list.add(new IotSensorInfo(sensorList.get(i).getSensor_device_id(), sensorList.get(i).getPort_id(), Float.valueOf((float)rh + 0.0f), deviceCode));
                                        }
                                    }
                                    MinaServer.threadPool.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            String body = Util.json.object2Json(list);
                                            String url = Constants.URL.SENSORS_DATA;
                                            HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                                        }
                                    });
                                }
                            } else {
                                lockResult3.setFlag(false);
                            }
                            Thread.sleep(120L);
                        }
                        break block54;
                    }
                    List<IotSensorInfoBO> iotSensorInfos = this.nodeInfo.getIotSensorList();
                    if (ObjectUtil.isEmpty(iotSensorInfos).booleanValue()) break block54;
                    int vseq = (int)Math.random() * 1000;
                    for (IotSensorInfoBO obj : iotSensorInfos) {
                        ModbusConfig sensorConfig = (ModbusConfig)JSON.parseObject((String)obj.getInfos(), ModbusConfig.class);
                        if (ObjectUtil.isEmpty(sensorConfig).booleanValue()) {
                            sensorConfig = new ModbusConfig();
                        }
                        if (ObjectUtil.isEmpty(obj.getSensor_device_id()).booleanValue()) {
                            return;
                        }
                        byte[] seqs = Util.protocal.octInt2ByteArray(++vseq, 2);
                        byte[] command = new byte[]{0, 0, 0, 0, 0, 6, 1, 3};
                        command[0] = seqs[0];
                        command[1] = seqs[1];
                        command[6] = (byte)Integer.parseInt(obj.getSensor_device_id() + "");
                        Byte.parseByte(obj.getSensor_device_id() + "");
                        command[7] = "01".equals(sensorConfig.getFcode()) ? 1 : ("02".equals(sensorConfig.getFcode()) ? 2 : ("03".equals(sensorConfig.getFcode()) ? 3 : ("04".equals(sensorConfig.getFcode()) ? 4 : ("05".equals(sensorConfig.getFcode()) ? 1 : ("06".equals(sensorConfig.getFcode()) ? 3 : 3)))));
                        command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(this.whole2simple(obj.getPort_id()), 2));
                        command = "float".equals(sensorConfig.getType()) || "uint32".equals(sensorConfig.getType()) || "int32".equals(sensorConfig.getType()) ? Util.protocal.append(command, (byte)0, (byte)2) : Util.protocal.append(command, (byte)0, (byte)1);
                        if (ObjectUtil.isNotEmpty(session.getAttribute("deviceFlag")).booleanValue()) continue;
                        if (Cache.deviceMap.containsKey(deviceCode)) {
                            HashMap<String, String> map3 = new HashMap<String, String>();
                            map3.put("askii", Util.binhexoct.bytesToHex(command));
                            map3.put("byte", Util.binhexoct.bytesToHex(command));
                            map3.put("direction", "1");
                            map3.put("time", new Date().getTime() + "");
                            MqttService.pubMessage(JSON.toJSONString(map3), "/sys/debug/" + deviceCode);
                        }
                        LockResult lockResult = (LockResult)session.getAttribute(realDataLock);
                        int sleepCount = 0;
                        while (lockResult.getFlag().booleanValue()) {
                            Thread.sleep(100L);
                            if (sleepCount++ <= 20) continue;
                            return;
                        }
                        LockResult lockResult3 = lockResult;
                        synchronized (lockResult3) {
                            lockResult = (LockResult)session.getAttribute(realDataLock);
                            lockResult.setFlag(true);
                            int i = repeatTimes;
                            while (i-- > 0) {
                                Util.mina.write(session, command);
                                lockResult.wait(timeOut.intValue());
                                if (lockResult.getFlag().booleanValue()) continue;
                            }
                        }
                        if (!lockResult.getFlag().booleanValue()) {
                            byte[] data = (byte[])session.getAttribute(realData);
                            int respVisitorSeq = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 0, 1));
                            if (respVisitorSeq == vseq) {
                                final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                                float rh = 0.0f;
                                if ("float".equals(sensorConfig.getType())) {
                                    rh = "CDAB".equals(sensorConfig.getOrder()) ? Util.ByteArrayConveter.getFloat3412(data, 9) : ("DCBA".equals(sensorConfig.getOrder()) ? Util.ByteArrayConveter.getFloat4321(data, 9) : ("BADC".equals(sensorConfig.getOrder()) ? Util.ByteArrayConveter.getFloat2143(data, 9) : Util.ByteArrayConveter.getFloat(data, 9)));
                                } else if ("int".equals(sensorConfig.getType())) {
                                    Object[] objectArray = new Object[]{10};
                                    rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 9, objectArray));
                                    if (rh > 32767.0f) {
                                        rh -= 65536.0f;
                                    }
                                } else if ("uint32".equals(sensorConfig.getType())) {
                                    rh = "CDAB".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt3412(data, 9) : ("DCBA".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt4321(data, 9) : ("BADC".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt2143(data, 9) : (float)Util.ByteArrayConveter.getInt(data, 9)));
                                } else if ("int32".equals(sensorConfig.getType())) {
                                    rh = "CDAB".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt3412(data, 9) : ("DCBA".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt4321(data, 9) : ("BADC".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt2143(data, 9) : (float)Util.ByteArrayConveter.getInt(data, 9)));
                                    if (rh > 2.1474836E9f) {
                                        double srh = rh - 4.2949673E9f;
                                        rh = (float)srh;
                                    }
                                } else {
                                    rh = data[8] == 1 ? (float)(data[9] & 1) : (float)Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 9, 10));
                                }
                                list.add(new IotSensorInfo(obj.getSensor_device_id() + "", obj.getPort_id(), Float.valueOf(rh + 0.0f), deviceCode.toString()));
                                MinaServer.threadPool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        String body = Util.json.object2Json(list);
                                        String url = Constants.URL.SENSORS_DATA;
                                        HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                                    }
                                });
                            }
                        } else {
                            lockResult.setFlag(false);
                        }
                        Thread.sleep(120L);
                    }
                    break block54;
                }
                Timer timeTask = Cache.timerTaskMap.get(this.nodeInfo.getDevice_code());
                timeTask.cancel();
                timeTask = null;
                Cache.timerTaskMap.remove(this.nodeInfo.getDevice_code());
            }
            catch (Exception e) {
                this.cancel();
                if (!ObjectUtil.isNotEmpty(session).booleanValue()) break block54;
                session.close(true);
            }
        }
    }

    private Integer whole2simple(Integer val) {
        val = val <= 9999 ? Integer.valueOf(val - 1) : (val >= 10001 && val <= 19999 ? Integer.valueOf(val - 10001) : (val >= 30001 && val <= 39999 ? Integer.valueOf(val - 30001) : (val >= 40001 && val <= 49999 ? Integer.valueOf(val - 40001) : Integer.valueOf(0))));
        return val;
    }

    private Integer simple2whole(Integer val, Integer fcode) {
        if (fcode == 2) {
            val = val + 10001;
        } else if (fcode == 3 || fcode == 6) {
            val = val + 40001;
        } else if (fcode == 4) {
            val = val + 30001;
        } else if (fcode == 1 || fcode == 5) {
            val = val + 1;
        }
        return val;
    }

    @Override
    public boolean match(IoSession session, byte[] data, String msg) {
        return false;
    }

    @Override
    public void logout(IoSession session) {
        Timer timeTask = Cache.timerTaskMap.get(session.getAttribute("deviceId"));
        if (ObjectUtil.isNotEmpty(timeTask).booleanValue()) {
            timeTask.cancel();
            timeTask = null;
            Cache.timerTaskMap.remove(session.getAttribute("deviceId"));
        }
        IotNodeInfo iotNodeInfo = new IotNodeInfo();
        iotNodeInfo.setDevice_code(session.getAttribute("deviceId") + "");
        iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.offline);
        iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
        String body = Util.json.object2Json(iotNodeInfo);
        HttpServiceSender.doPut(Constants.URL.NODE_INFO, Config.IOT_USER_KEY, body);
    }
}

