/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.protocal;

import com.lpro.iot.bean.IotNodeInfoBO;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Cache;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.protocal.ProtocalFactory;
import com.lpro.iot.server.ServerIoHandler;
import com.lpro.iot.utils.MD5Util;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import org.apache.mina.core.session.IoSession;

public class Protocal {
    public static void main(String[] args) {
        System.out.println(MD5Util.MD5Encode("user", "").subSequence(0, 6));
    }

    public static void loginProtocal(IoSession session, byte[] data, String msg) {
        String[] deviceInfos;
        String protocals = Config.IOT_PROTOCAL;
        String[] protocal2 = protocals.split(",");
        if (ObjectUtil.isEmpty(protocal2).booleanValue()) {
            return;
        }
        for (String subProtocal : protocal2) {
            boolean flag = ProtocalFactory.getInstance(subProtocal).match(session, data, msg);
            if (!flag) continue;
            ProtocalFactory.getInstance(subProtocal).loginProtocal(session, data, msg, null);
            return;
        }
        if (data.length > 300) {
            return;
        }
        if (msg.contains(",") && (deviceInfos = msg.split(","))[1].equals(MD5Util.MD5Encode(deviceInfos[0] + "iot2yun", "").substring(0, 6))) {
            IoSession transferSession = Cache.nodeIdsessionMap.get(deviceInfos[0]);
            if (ObjectUtil.isEmpty(transferSession).booleanValue() || ObjectUtil.isNotEmpty(transferSession.getAttribute("deviceFlag")).booleanValue()) {
                Util.mina.writeStr(session, "failure");
                return;
            }
            session.setAttribute("deviceTransfer", 1);
            session.setAttribute("deviceSession", transferSession);
            transferSession.setAttribute("deviceFlag", 1);
            transferSession.setAttribute("deviceSession", session);
            Util.mina.writeStr(session, "success");
            return;
        }
        String deviceCode = msg;
        if (ObjectUtil.isNotEmpty(deviceCode).booleanValue()) {
            ServerIoHandler.LOGGER.info("Login Code: " + deviceCode);
            ReturnObj obj = Util.NodeDevice.loginReturn(deviceCode);
            if (obj != null && obj.getStatus() == Code.ResponseCode.OK + 0 && ObjectUtil.isNotEmpty(obj.getData()).booleanValue()) {
                IotNodeInfoBO nodeInfo = obj.getData();
                if (ObjectUtil.isNotEmpty(nodeInfo.getIot_protocal_category()).booleanValue()) {
                    try {
                        ProtocalFactory.getInstance(nodeInfo.getIot_protocal_category()).loginProtocal(session, data, msg, obj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                session.close(true);
            }
        }
    }

    public static void analysisData(IoSession session, byte[] data, String msg) {
        String deviceCategory = session.getAttribute("ProtocolCategory").toString();
        ProtocalFactory.getInstance(deviceCategory).analysisData(session, data, msg);
    }

    public static void execServer(IoSession session, byte[] data, String msg) {
        String subStr = msg.split(":")[1];
        String[] commands = subStr.split(",");
        String nodeDeviceCode = commands[1];
        if (!("mqtt_control".equals(commands[0]) || "param_mqtt_write".equalsIgnoreCase(commands[0]) || "param_mqtt_read".equalsIgnoreCase(commands[0]))) {
            if ("reset".equals(commands[0])) {
                ReturnObj obj;
                IoSession sessionDeviceCode = Cache.nodeIdsessionMap.get(nodeDeviceCode);
                if (sessionDeviceCode != null && (obj = Util.NodeDevice.syncDeviceReturn(nodeDeviceCode)).getStatus() == Code.ResponseCode.OK + 0) {
                    sessionDeviceCode.setAttribute("NODE_SENSORS_DATA", obj.getData());
                }
            } else if ("param_write".equalsIgnoreCase(commands[0])) {
                IoSession sessionDeviceCode = Cache.nodeIdsessionMap.get(nodeDeviceCode);
                if (sessionDeviceCode != null) {
                    String deviceCategory = sessionDeviceCode.getAttribute("ProtocolCategory").toString();
                    ProtocalFactory.getInstance(deviceCategory).execServer(sessionDeviceCode, data, msg);
                }
            } else if ("param_read".equalsIgnoreCase(commands[0])) {
                IoSession sessionDeviceCode = Cache.nodeIdsessionMap.get(nodeDeviceCode);
                if (sessionDeviceCode != null) {
                    String deviceCategory = sessionDeviceCode.getAttribute("ProtocolCategory").toString();
                    ProtocalFactory.getInstance(deviceCategory).execServer(sessionDeviceCode, data, msg);
                }
            } else {
                IoSession sessionDeviceCode = Cache.nodeIdsessionMap.get(nodeDeviceCode);
                if (sessionDeviceCode != null) {
                    String deviceCategory = sessionDeviceCode.getAttribute("ProtocolCategory").toString();
                    ProtocalFactory.getInstance(deviceCategory).execServer(sessionDeviceCode, data, msg);
                }
            }
        }
    }
}

