/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.mqtt;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.common.Cache;
import com.lpro.iot.dto.Brower2LpmDto;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.protocal.Protocal;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import java.util.Date;
import org.apache.mina.core.session.IoSession;

public class MessageHandler
implements Runnable {
    private String message;
    private String topic;
    private byte[] msg;

    public MessageHandler(byte[] msg, String message, String topic) {
        this.message = message;
        this.topic = topic;
        this.msg = msg;
    }

    @Override
    public void run() {
        try {
            if (this.topic.contains("/lpm")) {
                Protocal.execServer(null, this.msg, this.message);
            } else if (this.topic.contains("/transmit")) {
                Brower2LpmDto browerDto = (Brower2LpmDto)JSON.parseObject((String)this.message, Brower2LpmDto.class);
                Integer messageType = browerDto.getMessageType();
                String deviceCode = browerDto.getDeviceCode();
                if (messageType == 1) {
                    Cache.deviceMap.put(deviceCode, new Date().getTime());
                } else {
                    IoSession session = Cache.nodeIdsessionMap.get(deviceCode);
                    if (ObjectUtil.isNotEmpty(session).booleanValue()) {
                        Integer dataType = browerDto.getDataType();
                        if (dataType == 1) {
                            byte[] sdata = Util.protocal.hexString2ByteArray(browerDto.getData().replaceAll(" ", ""), new int[0]);
                            Util.mina.write(session, sdata);
                        } else {
                            Util.mina.writeStr(session, browerDto.getData());
                        }
                    } else {
                        MqttService.pubMessage("error", "/sys/debug/" + deviceCode);
                    }
                }
            }
        }
        catch (Exception e) {
            MqttService.LOGGER.error(this.message);
        }
    }
}

