/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.utils;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.bean.IotNodeInfo;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.common.Constants;
import com.lpro.iot.utils.HttpServiceSender;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IoSession;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public class Util {
    public static boolean getBit(int num, int i) {
        return (num & 1 << i) != 0;
    }

    public static void main(String[] args) {
        file.getClasssFromJarFile("c:/lsm.jar", "com.loygra.lsm.service.impl.camel.task");
    }

    public static class ByteArrayConveter {
        public static byte strOtc2Byte(String c) {
            return (byte)Integer.parseInt(c);
        }

        public static byte[] getByteArray(char c) {
            byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
            return b;
        }

        public static char getChar(byte[] arr, int index) {
            return (char)(0xFF00 & arr[index] << 8 | 0xFF & arr[index + 1]);
        }

        public static byte[] getByteArray(short s) {
            byte[] b = new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)};
            return b;
        }

        public static short getShort(byte[] arr, int index) {
            return (short)(0xFF00 & arr[index] << 8 | 0xFF & arr[index + 1]);
        }

        public static byte[] getByteArray(int i) {
            byte[] b = new byte[]{(byte)((i & 0xFF000000) >> 24), (byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF00) >> 8), (byte)(i & 0xFF)};
            return b;
        }

        public static byte[] getByteArrayLittle(int i) {
            byte[] b = new byte[2];
            b[1] = (byte)((i & 0xFF00) >> 8);
            b[0] = (byte)(i & 0xFF);
            return b;
        }

        public static int getInt(byte[] arr, int index) {
            return 0xFF000000 & arr[index + 0] << 24 | 0xFF0000 & arr[index + 1] << 16 | 0xFF00 & arr[index + 2] << 8 | 0xFF & arr[index + 3];
        }

        public static byte[] getByteArray(float f) {
            int intbits = Float.floatToIntBits(f);
            return ByteArrayConveter.getByteArray(intbits);
        }

        public static float getFloat(byte[] arr, int index) {
            return Float.intBitsToFloat(ByteArrayConveter.getInt(arr, index));
        }

        public static float getFloat3412(byte[] arr, int index) {
            return Float.intBitsToFloat(ByteArrayConveter.getInt3412(arr, index));
        }

        public static float getFloat4321(byte[] arr, int index) {
            return Float.intBitsToFloat(ByteArrayConveter.getInt4321(arr, index));
        }

        public static float getFloat2143(byte[] arr, int index) {
            return Float.intBitsToFloat(ByteArrayConveter.getInt2143(arr, index));
        }

        public static int getInt2143(byte[] arr, int index) {
            return 0xFF000000 & arr[index + 1] << 24 | 0xFF0000 & arr[index + 0] << 16 | 0xFF00 & arr[index + 3] << 8 | 0xFF & arr[index + 2];
        }

        public static int getInt3412(byte[] arr, int index) {
            return 0xFF000000 & arr[index + 2] << 24 | 0xFF0000 & arr[index + 3] << 16 | 0xFF00 & arr[index + 0] << 8 | 0xFF & arr[index + 1];
        }

        public static int getInt4321(byte[] arr, int index) {
            return 0xFF000000 & arr[index + 3] << 24 | 0xFF0000 & arr[index + 2] << 16 | 0xFF00 & arr[index + 1] << 8 | 0xFF & arr[index + 0];
        }

        public static byte[] getByteArray(long l) {
            byte[] b = new byte[]{(byte)(0xFFL & l >> 56), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l)};
            return b;
        }

        public static long getLong(byte[] arr, int index) {
            return 0xFF00000000000000L & (long)arr[index + 0] << 56 | 0xFF000000000000L & (long)arr[index + 1] << 48 | 0xFF0000000000L & (long)arr[index + 2] << 40 | 0xFF00000000L & (long)arr[index + 3] << 32 | 0xFF000000L & (long)arr[index + 4] << 24 | 0xFF0000L & (long)arr[index + 5] << 16 | 0xFF00L & (long)arr[index + 6] << 8 | 0xFFL & (long)arr[index + 7];
        }

        public static byte[] getByteArray(double d) {
            long longbits = Double.doubleToLongBits(d);
            return ByteArrayConveter.getByteArray(longbits);
        }

        public static double getDouble(byte[] arr, int index) {
            return Double.longBitsToDouble(ByteArrayConveter.getLong(arr, index));
        }

        public static void main(String[] args) {
            block8: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    System.out.println(ByteOrder.nativeOrder());
                                    if (args.length < 1) {
                                        System.out.println("enter 'char' test method about char");
                                        System.out.println("enter 'short' test method about short");
                                        System.out.println("enter 'int' test method about int");
                                        System.out.println("enter 'float' test method about float");
                                        System.out.println("enter 'long' test method about long");
                                        System.out.println("enter 'double' test method about double");
                                        return;
                                    }
                                    if (!args[0].equals("char")) break block7;
                                    for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
                                        System.out.println(ByteArrayConveter.getChar(ByteArrayConveter.getByteArray(c), 0));
                                    }
                                    break block8;
                                }
                                if (!args[0].equals("short")) break block9;
                                for (short s = Short.MIN_VALUE; s < Short.MAX_VALUE; s = (short)(s + 1)) {
                                    System.out.println(ByteArrayConveter.getShort(ByteArrayConveter.getByteArray(s), 0));
                                }
                                break block8;
                            }
                            if (!args[0].equals("int")) break block10;
                            for (int i = Integer.MIN_VALUE; i < Integer.MAX_VALUE; ++i) {
                                System.out.println(ByteArrayConveter.getInt(ByteArrayConveter.getByteArray(i), 0));
                            }
                            break block8;
                        }
                        if (!args[0].equals("float")) break block11;
                        for (float f = Float.MIN_VALUE; f < Float.MAX_VALUE; f += 1.1111f) {
                            System.out.println(ByteArrayConveter.getFloat(ByteArrayConveter.getByteArray(f), 0));
                        }
                        break block8;
                    }
                    if (!args[0].equals("long")) break block12;
                    for (long l = Long.MIN_VALUE; l < Long.MAX_VALUE; ++l) {
                        System.out.println(ByteArrayConveter.getLong(ByteArrayConveter.getByteArray(l), 0));
                    }
                    break block8;
                }
                if (!args[0].equals("double")) break block8;
                for (double d = Double.MIN_VALUE; d < Double.MAX_VALUE; d += 1.111) {
                    System.out.println(ByteArrayConveter.getDouble(ByteArrayConveter.getByteArray(d), 0));
                }
            }
        }
    }

    public static class date {
        public static final String dtLong = "yyyyMMddHHmmss";
        public static final String dtVeryLong = "yyyyMMddHHmmssSSS";
        public static final String simple = "yyyy-MM-dd HH:mm";
        public static final String dtSimple = "yyyy-MM-dd";
        public static final String dtShort = "yyyyMMdd";
        public static final String dtShortPoint = "yyyy.MM.dd";
        public static final String dtLongPoint = "yyyy.MM.dd HH:mm";

        public static Date parse(String pattern, String text) throws ParseException {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.parse(text);
        }

        public static String format(String pattern, Date date2) throws ParseException {
            if (date2 == null) {
                return "-";
            }
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date2);
        }

        public static Date parseDtLong(String text) throws ParseException {
            return date.parse(dtLong, text);
        }

        public static Date parseSimple(String text) throws ParseException {
            return date.parse(simple, text);
        }

        public static String formatDtVeryLong(Date date2) throws ParseException {
            return date.format(dtVeryLong, date2);
        }

        public static String formatDtLong(Date date2) throws ParseException {
            return date.format(dtLong, date2);
        }

        public static String formatSimple(Date date2) throws ParseException {
            return date.format(simple, date2);
        }

        public static String[] getSpotData(Date date2) throws ParseException {
            if (date2 != null) {
                String yyyymm = date.formatDtVeryLong(date2);
                String[] data = new String[]{yyyymm.substring(0, 2), yyyymm.substring(2, 4), yyyymm.substring(4, 6), yyyymm.substring(6, 8)};
                return data;
            }
            return null;
        }

        public static String[] getSpotData(String date2) throws ParseException {
            if (Obj.isNotEmpty(date2)) {
                String[] data = new String[]{date2.substring(0, 2), date2.substring(2, 4), date2.substring(4, 6), date2.substring(6, 8)};
                return data;
            }
            return null;
        }

        public static String getNowTimeStr() {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            String time = (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
            return time;
        }

        public static Date getBeforeOneDateTime(Date day) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(day);
            int dateday = calendar.get(5);
            calendar.set(5, dateday - 1);
            return calendar.getTime();
        }

        public static Date getAfterOneDateTime(Date day) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(day);
            int dateday = calendar.get(5);
            calendar.set(5, dateday + 1);
            return calendar.getTime();
        }

        public static long getNowTime() {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11) - 8;
            int minute = calendar.get(12);
            int second = calendar.get(13);
            return (hour * 60 * 60 + minute * 60 + second) * 1000;
        }

        public static Date getCurrentDate() {
            GregorianCalendar calendar = new GregorianCalendar();
            GregorianCalendar today = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
            return today.getTime();
        }

        public static Date getCurrentDate(long time) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(time);
            GregorianCalendar today = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
            return today.getTime();
        }

        public static boolean isDateFromLong(Object data) {
            if (data != null && Obj.isActiveNumber(data)) {
                try {
                    new Date(Obj.parseLong(data));
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            return false;
        }

        public static String getTimeDesc(Date insert_time) {
            String insert_time_desc = "";
            long inTime = insert_time.getTime();
            long curTime = System.currentTimeMillis();
            double dValue = Math.ceil((curTime - inTime) / 1000L / 60L);
            insert_time_desc = dValue < 1.0 ? "\u521a\u521a" : (dValue < 60.0 ? (long)dValue + "\u5206\u949f\u524d" : (dValue < 1440.0 ? (long)Math.floor(dValue / 60.0) + "\u5c0f\u65f6\u524d" : (dValue < 43200.0 ? (long)Math.floor(dValue / 60.0 / 24.0) + "\u5929\u524d" : (dValue < 525600.0 ? (long)Math.floor(dValue / 60.0 / 24.0 / 30.0) + "\u6708\u524d" : (long)Math.floor(dValue / 60.0 / 24.0 / 365.0) + "\u5e74\u524d"))));
            return insert_time_desc;
        }

        public static long getMinusFromCurrent(Timestamp ts, int ... minus_seconds) {
            long curTimeMill = System.currentTimeMillis();
            if (minus_seconds.length > 0) {
                return curTimeMill - ts.getTime() - (long)(minus_seconds[0] * 1000);
            }
            return System.currentTimeMillis() - ts.getTime();
        }

        public static long getMinusFromCurrent(Date date2, int ... minus_seconds) {
            long curTimeMill = System.currentTimeMillis();
            if (minus_seconds.length > 0) {
                return curTimeMill - date2.getTime() - (long)(minus_seconds[0] * 1000);
            }
            return curTimeMill - date2.getTime();
        }
    }

    public static class crc {
        private static final char[] CTCTAB16 = new char[]{'\u0000', '\u1189', '\u2312', '\u329b', '\u4624', '\u57ad', '\u6536', '\u74bf', '\u8c48', '\u9dc1', '\uaf5a', '\ubed3', '\uca6c', '\udbe5', '\ue97e', '\uf8f7', '\u1081', '\u0108', '\u3393', '\u221a', '\u56a5', '\u472c', '\u75b7', '\u643e', '\u9cc9', '\u8d40', '\ubfdb', '\uae52', '\udaed', '\ucb64', '\uf9ff', '\ue876', '\u2102', '\u308b', '\u0210', '\u1399', '\u6726', '\u76af', '\u4434', '\u55bd', '\uad4a', '\ubcc3', '\u8e58', '\u9fd1', '\ueb6e', '\ufae7', '\uc87c', '\ud9f5', '\u3183', '\u200a', '\u1291', '\u0318', '\u77a7', '\u662e', '\u54b5', '\u453c', '\ubdcb', '\uac42', '\u9ed9', '\u8f50', '\ufbef', '\uea66', '\ud8fd', '\uc974', '\u4204', '\u538d', '\u6116', '\u709f', '\u0420', '\u15a9', '\u2732', '\u36bb', '\uce4c', '\udfc5', '\ued5e', '\ufcd7', '\u8868', '\u99e1', '\uab7a', '\ubaf3', '\u5285', '\u430c', '\u7197', '\u601e', '\u14a1', '\u0528', '\u37b3', '\u263a', '\udecd', '\ucf44', '\ufddf', '\uec56', '\u98e9', '\u8960', '\ubbfb', '\uaa72', '\u6306', '\u728f', '\u4014', '\u519d', '\u2522', '\u34ab', '\u0630', '\u17b9', '\uef4e', '\ufec7', '\ucc5c', '\uddd5', '\ua96a', '\ub8e3', '\u8a78', '\u9bf1', '\u7387', '\u620e', '\u5095', '\u411c', '\u35a3', '\u242a', '\u16b1', '\u0738', '\uffcf', '\uee46', '\udcdd', '\ucd54', '\ub9eb', '\ua862', '\u9af9', '\u8b70', '\u8408', '\u9581', '\ua71a', '\ub693', '\uc22c', '\ud3a5', '\ue13e', '\uf0b7', '\u0840', '\u19c9', '\u2b52', '\u3adb', '\u4e64', '\u5fed', '\u6d76', '\u7cff', '\u9489', '\u8500', '\ub79b', '\ua612', '\ud2ad', '\uc324', '\uf1bf', '\ue036', '\u18c1', '\u0948', '\u3bd3', '\u2a5a', '\u5ee5', '\u4f6c', '\u7df7', '\u6c7e', '\ua50a', '\ub483', '\u8618', '\u9791', '\ue32e', '\uf2a7', '\uc03c', '\ud1b5', '\u2942', '\u38cb', '\u0a50', '\u1bd9', '\u6f66', '\u7eef', '\u4c74', '\u5dfd', '\ub58b', '\ua402', '\u9699', '\u8710', '\uf3af', '\ue226', '\ud0bd', '\uc134', '\u39c3', '\u284a', '\u1ad1', '\u0b58', '\u7fe7', '\u6e6e', '\u5cf5', '\u4d7c', '\uc60c', '\ud785', '\ue51e', '\uf497', '\u8028', '\u91a1', '\ua33a', '\ub2b3', '\u4a44', '\u5bcd', '\u6956', '\u78df', '\u0c60', '\u1de9', '\u2f72', '\u3efb', '\ud68d', '\uc704', '\uf59f', '\ue416', '\u90a9', '\u8120', '\ub3bb', '\ua232', '\u5ac5', '\u4b4c', '\u79d7', '\u685e', '\u1ce1', '\u0d68', '\u3ff3', '\u2e7a', '\ue70e', '\uf687', '\uc41c', '\ud595', '\ua12a', '\ub0a3', '\u8238', '\u93b1', '\u6b46', '\u7acf', '\u4854', '\u59dd', '\u2d62', '\u3ceb', '\u0e70', '\u1ff9', '\uf78f', '\ue606', '\ud49d', '\uc514', '\ub1ab', '\ua022', '\u92b9', '\u8330', '\u7bc7', '\u6a4e', '\u58d5', '\u495c', '\u3de3', '\u2c6a', '\u1ef1', '\u0f78'};

        public static boolean validation(String vData, String code) {
            int codeVal;
            int calCrc16 = crc.getCrc16(vData);
            return calCrc16 == (codeVal = Integer.parseInt(code.replace(" ", ""), 16));
        }

        public static int getCrc16(String hex) {
            String[] hexArr = hex.split(" ");
            byte[] data = new byte[hexArr.length];
            for (int i = 0; i < hexArr.length; ++i) {
                data[i] = (byte)Integer.parseInt(hexArr[i], 16);
            }
            return crc.getCrc16(data, data.length);
        }

        public static int getCrc16(byte[] pData, int nLength) {
            int fcs = 65535;
            int i = 0;
            while (nLength > 0) {
                fcs = fcs >> 8 ^ CTCTAB16[(fcs ^ pData[i]) & 0xFF];
                --nLength;
                ++i;
            }
            return ~fcs & 0xFFFF;
        }

        public static int getCrc16(byte[] pData) {
            return crc.getCrc16(pData, pData.length);
        }

        public static String getCRC16(byte[] bytes, Boolean flag) {
            int CRC = 65535;
            int POLYNOMIAL = 40961;
            for (int i = 0; i < bytes.length; ++i) {
                CRC ^= bytes[i];
                for (int j = 0; j < 8; ++j) {
                    if ((CRC & 1) == 1) {
                        CRC >>= 1;
                        CRC ^= POLYNOMIAL;
                        continue;
                    }
                    CRC >>= 1;
                }
            }
            if (flag.booleanValue()) {
                CRC = (CRC & 0xFF00) >> 8 | (CRC & 0xFF) << 8;
            }
            return Integer.toHexString(CRC);
        }

        public static Integer getCRC162Int(byte[] bytes, Boolean flag) {
            int CRC = 65535;
            int POLYNOMIAL = 40961;
            for (int i = 0; i < bytes.length; ++i) {
                CRC = bytes[i] < 0 ? (CRC ^= bytes[i] + 256) : (CRC ^= bytes[i]);
                for (int j = 0; j < 8; ++j) {
                    if ((CRC & 1) == 1) {
                        CRC >>= 1;
                        CRC ^= POLYNOMIAL;
                        continue;
                    }
                    CRC >>= 1;
                }
            }
            if (flag.booleanValue()) {
                CRC = (CRC & 0xFF00) >> 8 | (CRC & 0xFF) << 8;
            }
            return CRC;
        }

        public static Integer getCRC162Int(byte[] bytes, Boolean flag, Integer from, Integer to) {
            int CRC = 65535;
            int POLYNOMIAL = 40961;
            if (to > bytes.length) {
                to = bytes.length;
            }
            for (int i = from.intValue(); i < to; ++i) {
                CRC ^= bytes[i];
                for (int j = 0; j < 8; ++j) {
                    if ((CRC & 1) == 1) {
                        CRC >>= 1;
                        CRC ^= POLYNOMIAL;
                        continue;
                    }
                    CRC >>= 1;
                }
            }
            if (flag.booleanValue()) {
                CRC = (CRC & 0xFF00) >> 8 | (CRC & 0xFF) << 8;
            }
            return CRC;
        }

        public static Integer getLocalCRC16(byte[] bytes) {
            int CRC = 65535;
            for (int i = 0; i < bytes.length; ++i) {
                CRC = bytes[i] < 0 ? (CRC ^= bytes[i] + 256) : (CRC ^= bytes[i]);
                for (int j = 0; j < 8; ++j) {
                    if ((CRC & 1) == 1) {
                        CRC >>= 1;
                        CRC ^= 0x1021;
                        continue;
                    }
                    CRC >>= 1;
                }
            }
            CRC = (CRC & 0xFF00) >> 8 | (CRC & 0xFF) << 8;
            return CRC;
        }

        public static Integer getLocalCRC16(byte[] bytes, Integer from, Integer to) {
            int CRC = 65535;
            for (int i = from.intValue(); i < to; ++i) {
                CRC = bytes[i] < 0 ? (CRC ^= bytes[i] + 256) : (CRC ^= bytes[i]);
                for (int j = 0; j < 8; ++j) {
                    if ((CRC & 1) == 1) {
                        CRC >>= 1;
                        CRC ^= 0x1021;
                        continue;
                    }
                    CRC >>= 1;
                }
            }
            CRC = (CRC & 0xFF00) >> 8 | (CRC & 0xFF) << 8;
            return CRC;
        }

        public static void main(String[] args) throws InterruptedException {
        }
    }

    public static class reflect {
        public static Object getFieldValue(Object obj, String fieldName) {
            try {
                if (obj == null) {
                    return null;
                }
                Method getter = obj.getClass().getMethod("get" + Obj.upperFirstChar(fieldName), new Class[0]);
                return getter.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static Object setFieldValue(Object obj, String fieldName, Object fieldValue) {
            try {
                if (obj == null || fieldName == null || fieldValue == null) {
                    return null;
                }
                Method setter = obj.getClass().getMethod("set" + Obj.upperFirstChar(fieldName), fieldValue.getClass());
                return setter.invoke(obj, fieldValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class map {
        public static Object remove(Map<?, ?> map2, Object value) {
            if (map2.containsValue(value)) {
                for (Object key : map2.keySet()) {
                    if (!map2.get(key).equals(value)) continue;
                    map2.remove(key);
                    return key;
                }
            }
            return null;
        }
    }

    public static class file {
        public static List<String> getClassName(String packageName) throws URISyntaxException {
            String jarPath = Util.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File file2 = new File(jarPath);
            if (file2.isDirectory()) {
                String filePath = ClassLoader.getSystemResource("").getPath() + packageName.replace(".", "\\");
                return file.getClassName(filePath, null);
            }
            return file.getClasssFromJarFile(jarPath, packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<String> getClasssFromJarFile(String jarPaht, String packageName) {
            ArrayList<String> names = new ArrayList<String>();
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jarPaht);
                Enumeration<JarEntry> ee = jarFile.entries();
                while (ee.hasMoreElements()) {
                    JarEntry entry = ee.nextElement();
                    String name = entry.getName().replaceAll("/", ".");
                    if (!name.contains(packageName) || !name.matches("^.*class$")) continue;
                    names.add(name.substring(0, name.length() - 6));
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                if (null != jarFile) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return names;
        }

        private static List<String> getClassName(String filePath, List<String> className) {
            File[] childFiles;
            ArrayList<String> myClassName = new ArrayList<String>();
            File file2 = new File(filePath);
            for (File childFile : childFiles = file2.listFiles()) {
                if (childFile.isDirectory()) {
                    myClassName.addAll(file.getClassName(childFile.getPath(), myClassName));
                    continue;
                }
                String childFilePath = childFile.getPath();
                int startPos = childFilePath.indexOf("\\classes") + 9;
                if (startPos == 8) {
                    startPos = childFilePath.indexOf("\\bin") + 5;
                }
                childFilePath = childFilePath.substring(startPos, childFilePath.lastIndexOf("."));
                childFilePath = childFilePath.replace("\\", ".");
                myClassName.add(childFilePath);
            }
            return myClassName;
        }
    }

    public static class mina {
        public static int write(IoSession session, byte[] data) {
            int result = 0;
            try {
                if (session != null && session.isConnected()) {
                    IoBuffer buffer = IoBuffer.allocate(10);
                    buffer.setAutoExpand(true);
                    buffer.put(data);
                    buffer.flip();
                    session.write(buffer);
                } else {
                    result = 1;
                }
            }
            catch (Exception e) {
                result = 1;
            }
            return result;
        }

        public static void sessionFlush(IoSession session) {
            ((AbstractIoSession)session).getProcessor().flush(session);
        }

        public static int writeStr(IoSession session, String data) {
            int result = 0;
            try {
                IoBuffer buffer = IoBuffer.allocate(10);
                buffer.setAutoExpand(true);
                buffer.put(data.getBytes());
                buffer.flip();
                session.write(buffer);
            }
            catch (Exception e) {
                result = 1;
            }
            return result;
        }
    }

    public static class protocal {
        public static String getHexFromByte(byte data) {
            String val = binhexoct.intToHex(data);
            if (data < 0) {
                val = binhexoct.intToHex(data + 256);
            }
            return val;
        }

        public static Integer getOtcFromByte(byte data) {
            int val = data;
            if (data < 0) {
                val = data + 256;
            }
            return val;
        }

        public static String getOtcStrFromByte(byte data) {
            int val = data;
            if (data < 0) {
                val = data + 256;
            }
            return val + "";
        }

        public static String getOtcStrFromByte2l(byte data) {
            String sval;
            int val = data;
            if (data < 0) {
                val = data + 256;
            }
            if ((sval = val + "").length() < 2) {
                sval = "0" + val;
            }
            return sval;
        }

        public static String getHexStringFromBytes(byte[] data) {
            StringBuffer sb = new StringBuffer();
            if (data != null && data.length > 0) {
                for (int i = 0; i < data.length; ++i) {
                    String val = binhexoct.intToHex(data[i]);
                    if (data[i] < 0) {
                        val = binhexoct.intToHex(data[i] + 256);
                    }
                    sb.append(val);
                }
            }
            return sb.toString();
        }

        public static String getOctFromHexBytes(byte[] data, Object from, Object ... to) {
            if (data != null && data.length > 0 && from != null) {
                try {
                    int toIndex;
                    int fromIndex = Integer.parseInt(from.toString());
                    byte[] value = to != null && to.length > 0 ? (fromIndex >= (toIndex = Integer.parseInt(to[0].toString())) || toIndex <= 0 ? Arrays.copyOfRange(data, fromIndex, fromIndex + 1) : Arrays.copyOfRange(data, fromIndex, toIndex + 1)) : Arrays.copyOfRange(data, fromIndex, fromIndex + 1);
                    if (value != null && value.length > 0) {
                        long octValue = 0L;
                        int j = -1;
                        int i = value.length - 1;
                        while (i >= 0) {
                            int d = value[i];
                            if (d < 0) {
                                d += 256;
                            }
                            octValue += Math.round((double)d * Math.pow(16.0, 2 * j + 2));
                            --i;
                            ++j;
                        }
                        return new Long(octValue).toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static String getOctFromHexBytesLittle(byte[] data, Object from, Object ... to) {
            if (data != null && data.length > 0 && from != null) {
                try {
                    int toIndex;
                    int fromIndex = Integer.parseInt(from.toString());
                    byte[] value = to != null && to.length > 0 ? (fromIndex >= (toIndex = Integer.parseInt(to[0].toString())) || toIndex <= 0 ? Arrays.copyOfRange(data, fromIndex, fromIndex + 1) : Arrays.copyOfRange(data, fromIndex, toIndex + 1)) : Arrays.copyOfRange(data, fromIndex, fromIndex + 1);
                    if (value != null && value.length > 0) {
                        long octValue = 0L;
                        int j = -1;
                        int i = 0;
                        while (i <= value.length - 1) {
                            int d = value[i];
                            if (d < 0) {
                                d += 256;
                            }
                            octValue += Math.round((double)d * Math.pow(16.0, 2 * j + 2));
                            ++i;
                            ++j;
                        }
                        return new Long(octValue).toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static String bytesToString(byte[] data, Integer from, Integer to) {
            char[] tmp = new char[to - from];
            int j = 0;
            for (int i = from.intValue(); i < to; ++i) {
                tmp[j++] = (char)data[i];
            }
            return String.valueOf(tmp);
        }

        public static byte[] StringToBytes(String data) {
            char[] bb = data.toCharArray();
            byte[] array = new byte[bb.length];
            for (int i = 0; i < bb.length; ++i) {
                array[i] = (byte)bb[i];
            }
            return array;
        }

        public static byte[] StringToBytes(String data, Integer length) {
            char[] bb = data.toCharArray();
            byte[] array = new byte[bb.length];
            for (int i = 0; i < bb.length; ++i) {
                array[i] = (byte)bb[i];
            }
            if (array.length < length) {
                return protocal.concat(array, new byte[length - array.length]);
            }
            return array;
        }

        public static byte[] octString2ByteArray(String octString, int ... capacity) {
            return protocal.hexString2ByteArray(Integer.toHexString(Integer.parseInt(octString)), capacity);
        }

        public static byte[] octInt2ByteArray(Integer oct, int ... capacity) {
            return protocal.hexString2ByteArray(Integer.toHexString(oct), capacity);
        }

        public static byte[] hexString2ByteArray(String hexString, int ... capacity) {
            if (StringUtils.isNotEmpty(hexString)) {
                int length;
                if ((hexString = hexString.toLowerCase()).length() % 2 != 0) {
                    hexString = "0" + hexString;
                }
                if ((length = hexString.length() / 2) < 1) {
                    length = 1;
                }
                int size = length;
                if (capacity != null && capacity.length > 0 && capacity[0] >= length) {
                    size = capacity[0];
                }
                byte[] byteArray = new byte[size];
                int k = 0;
                for (int i = 0; i < size; ++i) {
                    if (i < size - length) {
                        byteArray[i] = 0;
                        continue;
                    }
                    byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
                    if (k + 1 < hexString.length()) {
                        byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
                        byteArray[i] = (byte)(high << 4 | low);
                    } else {
                        byteArray[i] = high;
                    }
                    k += 2;
                }
                return byteArray;
            }
            return null;
        }

        public static Byte hexString2Byte(String hexString) {
            byte[] data = protocal.hexString2ByteArray(hexString, new int[0]);
            if (data != null) {
                return data[0];
            }
            return null;
        }

        public static Byte oct2Byte(int octInt) {
            return protocal.hexString2Byte(Integer.toHexString(octInt));
        }

        public static Byte octString2Byte(String octString) {
            return protocal.hexString2Byte(Integer.toHexString(Integer.parseInt(octString)));
        }

        public static String toHexString(byte[] byteArray) {
            if (byteArray != null && byteArray.length > 0) {
                StringBuilder hexString = new StringBuilder();
                for (int i = 0; i < byteArray.length; ++i) {
                    if ((byteArray[i] & 0xFF) < 16) {
                        hexString.append("0");
                    }
                    hexString.append(Integer.toHexString(0xFF & byteArray[i]));
                }
                return hexString.toString().toLowerCase();
            }
            return null;
        }

        public static String byte2OctString(byte[] data) {
            return new BigInteger(protocal.toHexString(data), 16).toString();
        }

        public static byte[] getBytesByParam(String hexString, Object from, Object to) {
            if (StringUtils.isNotEmpty(hexString)) {
                int start = Integer.parseInt(from.toString());
                int end = Integer.parseInt(to.toString());
                return protocal.hexString2ByteArray(hexString, end - start + 1);
            }
            return null;
        }

        public static byte[] subByte(byte[] data, int srcPos, int length) {
            byte[] dbyte = new byte[length];
            System.arraycopy(data, srcPos, dbyte, 0, length);
            return dbyte;
        }

        public static byte[] concat(byte[] ... data) {
            if (data != null && data.length > 0) {
                int size = 0;
                for (int i = 0; i < data.length; ++i) {
                    size += data[i].length;
                }
                byte[] byteArray = new byte[size];
                int pos = 0;
                for (int i = 0; i < data.length; ++i) {
                    byte[] b = data[i];
                    for (int j = 0; j < b.length; ++j) {
                        byteArray[pos++] = b[j];
                    }
                }
                return byteArray;
            }
            return null;
        }

        public static byte[] append(byte[] datas, byte[] data) {
            if (datas == null) {
                return data;
            }
            if (data == null) {
                return datas;
            }
            return protocal.concat(datas, data);
        }

        public static byte[] append(byte[] datas, Byte data) {
            if (datas == null) {
                return new byte[]{data};
            }
            if (data == null) {
                return datas;
            }
            return protocal.concat(datas, {data});
        }

        public static byte[] append(byte[] datas, Byte ... data) {
            if (data != null && data.length > 0) {
                byte[] result = datas;
                for (int i = 0; i < data.length; ++i) {
                    result = protocal.append(result, data[i]);
                }
                return result;
            }
            return datas;
        }
    }

    public static class json {
        public static List<?> string2ObjectList(String jsonData, Class<?> target) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            List result = null;
            try {
                result = (List)mapper.readValue(jsonData, TypeFactory.collectionType(List.class, target));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return result;
        }

        public static Object string2Object(String jsonData, Class target) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            Object obj = null;
            try {
                obj = mapper.readValue((Reader)new StringReader(jsonData), target);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return obj;
        }

        public static String object2Json(Object obj) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            String json2 = null;
            try {
                json2 = mapper.writeValueAsString(obj);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return json2;
        }

        public static List<?> unmarshal2Objects(String src, Class target) throws Exception {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            List result = null;
            result = (List)mapper.readValue((Reader)new StringReader(src), TypeFactory.collectionType(ArrayList.class, target));
            return result;
        }

        public static <E> E unmarshal(String src, Class target) throws Exception {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            return (E)mapper.readValue((Reader)new StringReader(src), target);
        }

        public static <T> T convertLspJsonStr2Object(String jsonStr, Class<?> target) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                Map m = mapper.readValue(jsonStr, Map.class);
                if ("2".equals("" + m.get("status"))) {
                    Object data = m.get("data");
                    if (data instanceof List) {
                        JavaType javaType = mapper.getTypeFactory().constructParametricType(ArrayList.class, target);
                        return mapper.readValue(mapper.writeValueAsString(data), javaType);
                    }
                    Object destData = ((Map)data).get("data");
                    if (destData instanceof List) {
                        JavaType javaType = mapper.getTypeFactory().constructParametricType(ArrayList.class, target);
                        return mapper.readValue(mapper.writeValueAsString(destData), javaType);
                    }
                    return (T)mapper.readValue(mapper.writeValueAsString(data), target);
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static void main(String[] args) {
        }
    }

    public static class Obj
    extends StringUtils {
        public static String getCharacterString(String str, int position, int ... capacity) {
            String s = null;
            if (StringUtils.isNotEmpty(str)) {
                int size = str.length();
                if (position >= size) {
                    return null;
                }
                int n = 1;
                if (capacity.length > 0) {
                    n = capacity[0];
                }
                if (n <= 0) {
                    n = 1;
                } else if (n > size - position) {
                    n = size - position;
                }
                return str.substring(position, n + position);
            }
            return s;
        }

        public static boolean hasNull(Object ... objs) {
            if (objs == null || objs.length == 0) {
                return true;
            }
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] != null || !"".equals(Obj.getString(objs[i]))) continue;
                return true;
            }
            return false;
        }

        public static Boolean hasNoEmpty(Object ... obj) {
            for (int i = 0; i < obj.length; ++i) {
                if (!Obj.isEmpty(Obj.getString(obj[i]))) continue;
                return false;
            }
            return true;
        }

        public static boolean isActiveNumber(Object data) {
            if (data != null && Obj.isNotEmpty(data.toString())) {
                Pattern pattern = Pattern.compile("[1-9][0-9]*");
                return pattern.matcher(data.toString()).matches();
            }
            return false;
        }

        public static String getString(String str) {
            if (Obj.isNotEmpty(str)) {
                return str.trim().replaceAll("\t", "").replace("\n", "").replace("\r", "");
            }
            return "";
        }

        public static Boolean hasOneEmpty(Object ... obj) {
            for (int i = 0; i < obj.length; ++i) {
                if (!Obj.isEmpty(Obj.getString(obj[i]))) continue;
                return true;
            }
            return false;
        }

        public static String getString(Object o) {
            if (o == null) {
                return "";
            }
            return Obj.getString(o.toString());
        }

        public static Boolean isAllEmpty(Object ... obj) {
            for (int i = 0; i < obj.length; ++i) {
                if (!Obj.isNotEmpty(Obj.getString(obj[i]))) continue;
                return false;
            }
            return true;
        }

        public static String getTrimString(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj.toString().trim();
        }

        public static String upperFirstChar(String str) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }

        public static boolean isSameCharacter(String str) {
            if (StringUtils.isNotEmpty(str)) {
                String s = StringUtils.trimToEmpty(str).toLowerCase();
                return StringUtils.isEmpty(s.replace(s.substring(0, 1), ""));
            }
            return false;
        }

        public static boolean isContinuityCharacter(String str) {
            String s = StringUtils.trimToEmpty(str).toLowerCase();
            if (StringUtils.isNotEmpty(str)) {
                boolean continuity = true;
                char[] data = s.toCharArray();
                for (int i = 0; i < data.length - 1; ++i) {
                    char a = data[i];
                    char b = data[i + 1];
                    continuity = continuity && (a + '\u0001' == b || a - '\u0001' == b);
                }
                return continuity;
            }
            return false;
        }

        public static Integer[] convert2IntArray(String str, String split) {
            if (Obj.hasOneEmpty(str, split).booleanValue()) {
                return null;
            }
            Integer[] rst = null;
            try {
                String[] strs = str.split(split);
                rst = new Integer[strs.length];
                for (int i = 0; i < strs.length; ++i) {
                    rst[i] = Obj.parseInteger(strs[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rst;
        }

        public static Long[] convert2LongArray(String str, String split) {
            if (Obj.hasOneEmpty(str, split).booleanValue()) {
                return null;
            }
            Long[] rst = null;
            try {
                String[] strs = str.split(split);
                rst = new Long[strs.length];
                for (int i = 0; i < strs.length; ++i) {
                    rst[i] = Obj.parseLong(strs[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rst;
        }

        public static boolean equalInt(Object o1, Object o2) {
            int o1Int = Obj.parseIntData(o1);
            int o2Int = Obj.parseIntData(o2);
            return o1Int != -9999 && o2Int != -9999 && o1Int == o2Int;
        }

        public static boolean equalLong(Object o1, Object o2) {
            long o1Long = Obj.parseLongData(o1);
            long o2Long = Obj.parseLongData(o2);
            return o1Long != -9999L && o2Long != -9999L && o1Long == o2Long;
        }

        public static Long parseLong(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Long.parseLong(o.toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static Long parseLongData(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Long.parseLong(o.toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return -9999L;
        }

        public static Float parseFloat(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Float.valueOf(Float.parseFloat(o.toString().trim()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static Float parseFloatData(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Float.valueOf(Float.parseFloat(o.toString().trim()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Float.valueOf(-9999.0f);
        }

        public static Boolean parseBoolean(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    if ("false".equalsIgnoreCase(Obj.getString(o)) || "0".equals(Obj.getString(o))) {
                        return false;
                    }
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static Double parseDouble(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Double.parseDouble(o.toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static Double parseDoubleData(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Double.parseDouble(o.toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return -9999.99;
        }

        public static Integer parseIntData(Object o) {
            try {
                if (o != null && Obj.isNotEmpty(o.toString().trim())) {
                    return Integer.parseInt(o.toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return -9999;
        }

        public static Integer parseInteger(Object o) {
            Integer result = null;
            try {
                result = Integer.valueOf(Obj.getTrimString(o));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        public static String upFirstChar(String str) {
            return str.replaceFirst(str.substring(0, 1), str.substring(0, 1).toUpperCase());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String inputStream2String(InputStream is) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return sb.toString();
        }

        public static String fillStringWithQuote(Object src, String quote, int size) {
            String str = Obj.getString(src);
            int strSize = str.length();
            String result = str;
            if (strSize < size) {
                for (int i = size - strSize; i > 0; --i) {
                    result = quote + result;
                }
            }
            return result;
        }

        public static boolean isChinese(char c) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
            return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
        }

        public static boolean isChinese(String strName) {
            return strName.getBytes().length != strName.length();
        }

        public static List<String> getEnword(List<String> words) {
            ArrayList<String> enwords = new ArrayList<String>();
            for (int i = 0; i < words.size(); ++i) {
                String word = words.get(i);
                if (!Obj.isChinese(word)) continue;
                enwords.add(word);
            }
            return words;
        }

        public static String getUTF8(String str) throws UnsupportedEncodingException {
            return new String(str.getBytes("iso-8859-1"), "UTF-8");
        }
    }

    public static class binhexoct {
        public static void main(String[] args) {
            String str = "114200000001 0040 1040 20500.00 30500.02\r\n";
            System.out.println(Arrays.toString(str.getBytes()).replace(",", ""));
            System.out.println(binhexoct.bytesToHex(str.getBytes()));
            String hex = "01 0d 00 00 00 10 01 03 00 45 00 02 d5 de";
            System.out.println(Arrays.toString(binhexoct.hexToBytes(hex, " ")));
            System.out.println(binhexoct.binaryToHex("0000000010101000"));
        }

        public static String intToHex(int i) {
            String str = Integer.toHexString(i);
            if (str.length() % 2 != 0) {
                str = "0" + str;
            }
            return str;
        }

        public static byte[] hexToBytes(String str) {
            byte[] bytes = null;
            if (str.length() > 0 && str.length() % 2 == 0) {
                bytes = new byte[str.length() / 2];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = binhexoct.hexToByte(str.substring(2 * i, 2 * i + 2));
                }
            }
            return bytes;
        }

        public static byte[] hexToBytes(String str, String separator) {
            byte[] bytes = null;
            if ((str = str.replace(separator, "")).length() > 0 && str.length() % 2 == 0) {
                bytes = new byte[str.length() / 2];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = binhexoct.hexToByte(str.substring(2 * i, 2 * i + 2));
                }
            }
            return bytes;
        }

        public static byte hexToByte(String str) {
            int i = Integer.parseInt(str, 16);
            byte b = (byte)i;
            return b;
        }

        public static String bytesToHex(byte[] bytes) {
            StringBuffer hex = new StringBuffer();
            for (int i = 0; i < bytes.length; ++i) {
                hex.append(binhexoct.byteToHex(bytes[i]) + " ");
            }
            return hex.toString();
        }

        public static String byteToHex(byte b) {
            int i = b & 0xFF;
            return 0 <= i && i < 16 ? "0" + Integer.toHexString(i) : Integer.toHexString(i);
        }

        public static String binaryToHex(String binary) {
            StringBuffer hex = new StringBuffer();
            if (binary.length() % 8 == 0) {
                for (int i = 0; i < binary.length() - 7; i += 8) {
                    int temp = Integer.parseInt(binary.substring(i, i + 8), 2);
                    System.out.println(binary.substring(i, i + 8));
                    hex.append(temp < 16 ? "0" + Integer.toHexString(temp) + " " : Integer.toHexString(temp) + " ");
                }
            }
            return hex.toString();
        }

        public static String hexToBinary(String hex) {
            int tem = Integer.parseInt(hex, 16);
            return Integer.toBinaryString(tem);
        }

        public static String hexToASCII(String hex) {
            byte[] b = binhexoct.hexToBytes(hex);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < b.length; ++i) {
                sb.append((char)b[i]);
            }
            return sb.toString();
        }

        public static String hexToASCII(String hex, String separator) {
            hex = hex.replace(separator, "");
            byte[] b = binhexoct.hexToBytes(hex);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < b.length; ++i) {
                sb.append((char)b[i]);
            }
            return sb.toString();
        }

        public static boolean byteValueEqual(Object param1, Object param2) {
            if (param1 != null && param2 != null) {
                try {
                    int p1 = Integer.parseInt(param1.toString());
                    int p2 = Integer.parseInt(param2.toString());
                    if (p1 < 0) {
                        p1 = 256 + p1;
                    }
                    if (p2 < 0) {
                        p2 = 256 + p2;
                    }
                    return p1 == p2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public static int byteValue(Object param) {
            if (param != null) {
                try {
                    int p = Integer.parseInt(param.toString());
                    if (p < 0) {
                        p = 256 + p;
                    }
                    return p;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return -9999;
        }
    }

    public static class NodeDevice {
        public static ReturnObj login(String deviceCode) {
            IotNodeInfo iotNodeInfo = new IotNodeInfo();
            iotNodeInfo.setDevice_code(deviceCode);
            iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.online);
            iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
            String body = json.object2Json(iotNodeInfo);
            String url = Constants.URL.NODE_INFO;
            String[] reponse = HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
            return (ReturnObj)JSON.parseObject((String)reponse[1], ReturnObj.class);
        }

        public static ReturnObj loginReturn(String deviceCode) {
            IotNodeInfo iotNodeInfo = new IotNodeInfo();
            iotNodeInfo.setDevice_code(deviceCode);
            iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.online);
            iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
            String body = json.object2Json(iotNodeInfo);
            String url = Constants.URL.NODE_INFO;
            String[] reponse = HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
            return (ReturnObj)JSON.parseObject((String)reponse[1], ReturnObj.class);
        }

        public static ReturnObj syncDeviceReturn(String deviceCode) {
            IotNodeInfo iotNodeInfo = new IotNodeInfo();
            iotNodeInfo.setDevice_code(deviceCode);
            iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
            String body = json.object2Json(iotNodeInfo);
            String url = Constants.URL.SYNC_NODE;
            String[] reponse = HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
            return (ReturnObj)JSON.parseObject((String)reponse[1], ReturnObj.class);
        }
    }
}

