/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static final String dtLong = "yyyyMMddHHmmss";
    public static final String dtVeryLong = "yyyyMMddHHmmssSSS";
    public static final String simple = "yyyy-MM-dd HH:mm";
    public static final String simpleALL = "yyyy/MM/dd HH:mm:ss";
    public static final String dtSimple = "yyyy-MM-dd";
    public static final String dtShort = "yyyyMMdd";
    public static final String dtShortPoint = "yyyy.MM.dd";
    public static final String dtLongPoint = "yyyy.MM.dd HH:mm";

    public static Date parse(String pattern, String text) {
        try {
            if (StringUtils.isEmpty(text)) {
                return null;
            }
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.parse(text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String format(String pattern, Date date2) throws ParseException {
        if (date2 == null) {
            return "-";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date2);
    }

    public static Date parseDtLong(String text) throws ParseException {
        return DateUtils.parse(dtLong, text);
    }

    public static Date parseSimple(String text) throws ParseException {
        return DateUtils.parse(simple, text);
    }

    public static String formatDtVeryLong(Date date2) throws ParseException {
        return DateUtils.format(dtVeryLong, date2);
    }

    public static String formatDtLong(Date date2) throws ParseException {
        return DateUtils.format(dtLong, date2);
    }

    public static String formatSimple(Date date2) throws ParseException {
        return DateUtils.format(simple, date2);
    }

    public static String getNowTimeStr() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String time = (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":" + (second < 10 ? "0" + second : Integer.valueOf(second));
        return time;
    }

    public static Date getBeforeOneDateTime(Date day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        int dateday = calendar.get(5);
        calendar.set(5, dateday - 1);
        return calendar.getTime();
    }

    public static Date getAfterOneDateTime(Date day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        int dateday = calendar.get(5);
        calendar.set(5, dateday + 1);
        return calendar.getTime();
    }

    public static long getNowTime() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11) - 8;
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return (hour * 60 * 60 + minute * 60 + second) * 1000;
    }

    public static Date getCurrentDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar today = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        return today.getTime();
    }

    public static Date getCurrentDate(long time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(time);
        GregorianCalendar today = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        return today.getTime();
    }

    public static Date getDate(long time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(time);
        return calendar.getTime();
    }

    public static Boolean getTimeBeforetimes(Date time, Integer minute) {
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(12, -1 * minute);
        return nowTime.getTime().getTime() < time.getTime();
    }

    public static String getTimeDesc(Date insert_time) {
        String insert_time_desc = "";
        long inTime = insert_time.getTime();
        long curTime = System.currentTimeMillis();
        double dValue = Math.ceil((curTime - inTime) / 1000L / 60L);
        insert_time_desc = dValue < 1.0 ? "\u521a\u521a" : (dValue < 60.0 ? (long)dValue + "\u5206\u949f\u524d" : (dValue < 1440.0 ? (long)Math.floor(dValue / 60.0) + "\u5c0f\u65f6\u524d" : (dValue < 43200.0 ? (long)Math.floor(dValue / 60.0 / 24.0) + "\u5929\u524d" : (dValue < 525600.0 ? (long)Math.floor(dValue / 60.0 / 24.0 / 30.0) + "\u6708\u524d" : (long)Math.floor(dValue / 60.0 / 24.0 / 365.0) + "\u5e74\u524d"))));
        return insert_time_desc;
    }

    public static Date getDate(int type) {
        Date date2 = null;
        try {
            switch (type) {
                case 1: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, new Date()) + " 12:00");
                    break;
                }
                case 2: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getAfterOneDateTime(new Date())) + " 12:00");
                    break;
                }
                case 3: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getAfterOneDateTime(DateUtils.getAfterOneDateTime(new Date()))) + " 12:00");
                    break;
                }
                case 4: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, new Date()) + " 09:00");
                    break;
                }
                case 5: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, new Date()) + " 00:00");
                    break;
                }
                case 6: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getAfterOneDateTime(new Date())) + " 00:00");
                    break;
                }
                case 7: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getBeforeOneDateTime(new Date())) + " 00:00");
                    break;
                }
                case 8: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getMondayOfThisWeek()) + " 00:00");
                    break;
                }
                case 9: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getSundayOfThisWeek()) + " 23:59");
                    break;
                }
                case 10: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, new Date()) + " 23:59");
                    break;
                }
                case 11: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getFirstDayOfThisMonth()) + " 00:00");
                    break;
                }
                case 12: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, DateUtils.getLastDayOfThisMonth()) + " 23:59");
                    break;
                }
                case 13: {
                    date2 = DateUtils.parse(simple, DateUtils.format(dtSimple, new Date()) + " 23:59");
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date2;
    }

    public static void main(String[] args) {
        DateUtils.getDate(6);
        DateUtils.getDate(7);
        DateUtils.getDate(13);
    }

    public static Date getMondayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 1);
        return c.getTime();
    }

    public static Date getSundayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 7);
        return c.getTime();
    }

    private static Date getFirstDayOfThisMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    private static Date getLastDayOfThisMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static String getDateStrDt(int type) {
        try {
            return DateUtils.format(dtSimple, DateUtils.getDate(type));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static long getMinusFromCurrent(Timestamp ts, int ... minus_seconds) {
        long curTimeMill = System.currentTimeMillis();
        if (minus_seconds.length > 0) {
            return curTimeMill - ts.getTime() - (long)(minus_seconds[0] * 1000);
        }
        return System.currentTimeMillis() - ts.getTime();
    }

    public static long getMinusFromCurrent(Date date2, int ... minus_seconds) {
        long curTimeMill = System.currentTimeMillis();
        if (minus_seconds.length > 0) {
            return curTimeMill - date2.getTime() - (long)(minus_seconds[0] * 1000);
        }
        return curTimeMill - date2.getTime();
    }
}

