/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.serviceImpl;

import com.lpro.iot.common.Cache;
import com.lpro.iot.protocal.Protocal;
import com.lpro.iot.protocal.ProtocalFactory;
import com.lpro.iot.service.MsgHandlerService;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;

public class MsgHandlerServiceImpl
implements MsgHandlerService {
    @Override
    public void MsgHandler(IoSession session, Object message) {
        IoBuffer ioBuffer = (IoBuffer)message;
        byte[] data = new byte[ioBuffer.limit()];
        String msg = "";
        try {
            ioBuffer.get(data);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < data.length; ++i) {
                stringBuffer.append((char)data[i]);
            }
            msg = stringBuffer.toString();
            if (ObjectUtil.isNotEmpty(msg).booleanValue()) {
                if (msg.contains("IOT_SERVER_LPM")) {
                    Protocal.execServer(session, data, msg);
                } else if (session.containsAttribute("deviceId")) {
                    if (session.containsAttribute("deviceFlag")) {
                        IoSession destSession = (IoSession)session.getAttribute("deviceSession");
                        Util.mina.write(destSession, data);
                    } else if (Cache.nodeIdsessionMap.containsKey(session.getAttribute("deviceId"))) {
                        Protocal.analysisData(session, data, msg);
                    } else {
                        session.close(true);
                    }
                } else if (session.containsAttribute("deviceTransfer")) {
                    IoSession destSession = (IoSession)session.getAttribute("deviceSession");
                    Util.mina.write(destSession, data);
                } else {
                    Protocal.loginProtocal(session, data, msg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sessionClosed(IoSession session) {
        if (session.containsAttribute("deviceId")) {
            Cache.nodeIdsessionMap.remove(session.getAttribute("deviceId").toString());
            String deviceCategory = session.getAttribute("ProtocolCategory").toString();
            ProtocalFactory.getInstance(deviceCategory).logout(session);
            session.removeAttribute("deviceId");
        }
        if (ObjectUtil.isNotEmpty(session.getAttribute("deviceSession")).booleanValue()) {
            IoSession destSession = (IoSession)session.getAttribute("deviceSession");
            destSession.close(true);
        }
    }
}

