/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.server;

import com.lpro.iot.service.MsgHandlerService;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIoHandler
extends IoHandlerAdapter {
    protected static MsgHandlerService msgHandlerService = null;
    public static final Logger LOGGER = LoggerFactory.getLogger(ServerIoHandler.class);

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LOGGER.error(cause.getMessage());
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        try {
            msgHandlerService.MsgHandler(session, message);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        System.out.println("IDLE Count:" + session.getIdleCount(status));
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        String ip = session.getRemoteAddress().toString().split("\\:")[0];
        LOGGER.info(ip + " connection is open!");
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        msgHandlerService.sessionClosed(session);
    }
}

