/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.server;

import com.lpro.iot.common.Config;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.server.ServerIoHandler;
import com.lpro.iot.server.UdpSeverHandler;
import com.lpro.iot.serviceImpl.MsgHandlerServiceImpl;
import com.lpro.iot.serviceImpl.TaskServiceImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.core.session.ExpiringSessionRecycler;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaServer {
    public static Logger LOGGER = null;
    public static ExecutorService threadPool = Executors.newFixedThreadPool(15);

    public static void main(String[] args) throws IOException {
        try {
            if (args != null && args.length > 0) {
                Config.loadExtenalConfig(args);
            }
            System.setProperty("lpmKey", Config.IOT_LPM_KEY);
            LOGGER = LoggerFactory.getLogger(MinaServer.class);
            ServerIoHandler.msgHandlerService = new MsgHandlerServiceImpl();
            NioSocketAcceptor acceptor = new NioSocketAcceptor();
            acceptor.setHandler(new ServerIoHandler());
            IoSessionConfig cfg = acceptor.getSessionConfig();
            if (cfg instanceof SocketSessionConfig) {
                ((SocketSessionConfig)cfg).setReceiveBufferSize(2048);
                ((SocketSessionConfig)cfg).setReadBufferSize(2048);
                ((SocketSessionConfig)cfg).setKeepAlive(true);
                ((SocketSessionConfig)cfg).setSoLinger(0);
                ((SocketSessionConfig)cfg).setTcpNoDelay(true);
                ((SocketSessionConfig)cfg).setWriteTimeout(5000);
            }
            acceptor.bind(new InetSocketAddress(Config.IOT_PORT));
            threadPool.execute(new TaskServiceImpl());
            MqttService mqtt = new MqttService();
            if (Config.IOT_UDP_SWITCH) {
                NioDatagramAcceptor acceptorUdp = new NioDatagramAcceptor();
                acceptorUdp.getFilterChain().addLast("threadPool", new ExecutorFilter(Executors.newCachedThreadPool()));
                acceptorUdp.setHandler(new UdpSeverHandler());
                acceptorUdp.setSessionRecycler(new ExpiringSessionRecycler(15000));
                DatagramSessionConfig dcfg = acceptorUdp.getSessionConfig();
                dcfg.setReuseAddress(true);
                dcfg.setReceiveBufferSize(1024);
                dcfg.setSendBufferSize(1024);
                acceptorUdp.bind(new InetSocketAddress(Config.IOT_UDP_PORT));
                LOGGER.info("udp server startup listening on port:" + Config.IOT_UDP_PORT);
            }
        }
        catch (Exception e) {
            LOGGER.error("server startup error!" + e.getMessage());
            return;
        }
        LOGGER.info("tcp server startup listening on port:" + Config.IOT_PORT);
    }
}

