/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.server;

import com.lpro.iot.common.Config;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.server.ServerIoHandler;
import com.lpro.iot.server.UdpSeverHandler;
import com.lpro.iot.serviceImpl.MsgHandlerServiceImpl;
import com.lpro.iot.serviceImpl.TaskServiceImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.core.session.ExpiringSessionRecycler;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainServer {
    public static Logger LOGGER = null;
    public static ExecutorService threadPool = Executors.newFixedThreadPool(15);

    public static void main(String[] stringArray) throws IOException {
        try {
            if (stringArray != null && stringArray.length > 0) {
                Config.loadExtenalConfig(stringArray);
            }
            System.setProperty("lpmKey", Config.IOT_LPM_KEY);
            LOGGER = LoggerFactory.getLogger(MainServer.class);
            NioSocketAcceptor nioSocketAcceptor = new NioSocketAcceptor();
            ServerIoHandler serverIoHandler = new ServerIoHandler();
            ServerIoHandler.msgHandlerService = new MsgHandlerServiceImpl();
            nioSocketAcceptor.setHandler(serverIoHandler);
            IoSessionConfig ioSessionConfig = nioSocketAcceptor.getSessionConfig();
            if (ioSessionConfig instanceof SocketSessionConfig) {
                ((SocketSessionConfig)ioSessionConfig).setReceiveBufferSize(2048);
                ((SocketSessionConfig)ioSessionConfig).setReadBufferSize(2048);
                ((SocketSessionConfig)ioSessionConfig).setKeepAlive(true);
                ((SocketSessionConfig)ioSessionConfig).setSoLinger(0);
                ((SocketSessionConfig)ioSessionConfig).setTcpNoDelay(true);
                ((SocketSessionConfig)ioSessionConfig).setWriteTimeout(5000);
            }
            nioSocketAcceptor.bind(new InetSocketAddress(Config.IOT_PORT));
            threadPool.execute(new TaskServiceImpl());
            MqttService mqttService = new MqttService();
            if (Config.IOT_UDP_SWITCH) {
                NioDatagramAcceptor nioDatagramAcceptor = new NioDatagramAcceptor();
                nioDatagramAcceptor.getFilterChain().addLast("threadPool", new ExecutorFilter(Executors.newCachedThreadPool()));
                nioDatagramAcceptor.setHandler(new UdpSeverHandler());
                nioDatagramAcceptor.setSessionRecycler(new ExpiringSessionRecycler(15000));
                DatagramSessionConfig datagramSessionConfig = nioDatagramAcceptor.getSessionConfig();
                datagramSessionConfig.setReuseAddress(true);
                datagramSessionConfig.setReceiveBufferSize(1024);
                datagramSessionConfig.setSendBufferSize(1024);
                nioDatagramAcceptor.bind(new InetSocketAddress(Config.IOT_UDP_PORT));
                LOGGER.info("udp server startup listening on port:" + Config.IOT_UDP_PORT);
            }
        }
        catch (Exception exception) {
            LOGGER.error("server startup error!" + exception.getMessage());
            return;
        }
        LOGGER.info("tcp server startup listening on port:" + Config.IOT_PORT);
    }
}

