/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.protocal.impl;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.bean.IotNodeInfo;
import com.lpro.iot.bean.IotNodeInfoBO;
import com.lpro.iot.bean.IotSensorInfo;
import com.lpro.iot.bean.IotSensorInfoBO;
import com.lpro.iot.bean.LockResult;
import com.lpro.iot.bean.ModbusConfig;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Cache;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.common.Constants;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.protocal.Iprotocal;
import com.lpro.iot.server.MinaServer;
import com.lpro.iot.utils.CoordinateTransformUtil;
import com.lpro.iot.utils.HttpServiceSender;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.mina.core.session.IoSession;

public class ProtocalModbus
extends TimerTask
implements Iprotocal {
    public static final Integer repeatTimes = 1;
    public static final Integer timeOut = 5000;
    private static final String cmdLock = "CMD_LOCK";
    private static final String realData = "DATA";
    private static final String nodeSensorsData = "NODE_SENSORS_DATA";
    private IotNodeInfoBO nodeInfo;

    public static void main(String[] args) {
        String msg = "GPS:23.051302766187,112.95281793775\r\n";
        byte[] aa = Util.protocal.StringToBytes(msg);
        msg = msg.substring(4, msg.length() - 2);
        System.out.println(msg);
    }

    @Override
    public void loginProtocal(IoSession session, byte[] data, String msg, ReturnObj obj) {
        if (data.length > 100) {
            return;
        }
        String deviceCode = msg;
        if (obj == null) {
            obj = Util.NodeDevice.loginReturn(deviceCode);
        }
        if (obj.getStatus() == Code.ResponseCode.OK + 0 && ObjectUtil.isNotEmpty(obj.getData()).booleanValue()) {
            session.setAttribute("deviceId", deviceCode);
            session.setAttribute("ProtocolCategory", this.getClass().getSimpleName());
            LockResult lockResult = new LockResult();
            lockResult.setFlag(false);
            session.setAttribute(cmdLock, lockResult);
            session.setAttribute(nodeSensorsData, obj.getData());
            if (Cache.nodeIdsessionMap.containsKey(deviceCode)) {
                try {
                    Cache.nodeIdsessionMap.get(deviceCode).close(true);
                    if (Cache.timerTaskMap.containsKey(deviceCode)) {
                        Timer timeTask = Cache.timerTaskMap.get(deviceCode);
                        if (ObjectUtil.isNotEmpty(timeTask).booleanValue()) {
                            timeTask.cancel();
                            timeTask = null;
                        }
                        Cache.timerTaskMap.remove(deviceCode);
                    }
                    session.close(true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    session.close(true);
                    return;
                }
            }
            Cache.nodeIdsessionMap.put(deviceCode, session);
            Timer timeTask = new Timer();
            session.setAttribute("timer", timeTask.hashCode());
            Integer frequency = obj.getData().getFrequency();
            if (frequency != null && frequency + 0 > 0) {
                timeTask.schedule((TimerTask)new ProtocalModbus(obj.getData()), new Date(), (long)(frequency * 1000));
            } else {
                timeTask.schedule((TimerTask)new ProtocalModbus(obj.getData()), new Date(), 3000L);
            }
            Cache.timerTaskMap.put(deviceCode, timeTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analysisData(IoSession session, byte[] data, String msg) {
        LockResult lockResult;
        String deviceCode = session.getAttribute("deviceId") + "";
        if (Cache.deviceMap.containsKey(deviceCode)) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("askii", msg);
            map2.put("byte", Util.binhexoct.bytesToHex(data));
            map2.put("direction", "2");
            map2.put("time", new Date().getTime() + "");
            MqttService.pubMessage(JSON.toJSONString(map2), "/sys/debug/" + deviceCode);
        }
        if (msg.contains("GPS:")) {
            List<IotSensorInfoBO> sensorList = ((IotNodeInfoBO)session.getAttribute(nodeSensorsData)).getIotSensorList();
            final ArrayList<IotSensorInfoBO> list = new ArrayList<IotSensorInfoBO>();
            for (int i = 0; i < sensorList.size(); ++i) {
                if (sensorList.get(i).getIot_sensor_type() + 0 != 90) continue;
                sensorList.get(i).setStr_sdata(msg.substring(4, msg.length() - 2));
                sensorList.get(i).setSdata(Float.valueOf(0.0f));
                list.add(sensorList.get(i));
                MinaServer.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        String body = Util.json.object2Json(list);
                        String url = Constants.URL.SENSORS_DATA;
                        HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                    }
                });
                return;
            }
        }
        if (!ObjectUtil.isNotEmpty(data).booleanValue() || data.length <= 5 || data[1] <= 0 || data[1] > 6 || data[2] + 5 != data.length && data.length != 8) {
            return;
        }
        LockResult lockResult2 = lockResult = (LockResult)session.getAttribute(cmdLock);
        synchronized (lockResult2) {
            lockResult = (LockResult)session.getAttribute(cmdLock);
            session.setAttribute(realData, data);
            lockResult.setFlag(false);
            lockResult.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execServer(IoSession session, byte[] data, String msg) {
        block21: {
            String subStr = msg.split(":")[1];
            String[] commands = subStr.split(",");
            String type = commands[0];
            String deviceCode = (String)session.getAttribute("deviceId");
            if (ObjectUtil.isNotEmpty(session.getAttribute("deviceFlag")).booleanValue()) {
                return;
            }
            if ("control".equalsIgnoreCase(type) || "param_write".equalsIgnoreCase(type)) {
                Integer sensorDeviceId = Integer.parseInt(commands[2]);
                Integer portId = Integer.parseInt(commands[3]);
                Float datas = Float.valueOf(Float.parseFloat(commands[4]));
                int aa = msg.trim().indexOf(123);
                ModbusConfig modbus = null;
                if (aa > -1) {
                    modbus = (ModbusConfig)JSON.parseObject((String)msg.trim().substring(aa), ModbusConfig.class);
                }
                byte[] command = new byte[]{0, 6};
                if (ObjectUtil.isNotEmpty(modbus.getFcode()).booleanValue()) {
                    if ("06".equals(modbus.getFcode()) || "03".equals(modbus.getFcode())) {
                        command[1] = 6;
                    } else if ("05".equals(modbus.getFcode()) || "01".equals(modbus.getFcode())) {
                        command[1] = 5;
                    } else {
                        return;
                    }
                }
                command[0] = (byte)Integer.parseInt(sensorDeviceId + "");
                command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Integer.parseInt(portId + ""), 2));
                if (datas.floatValue() == 1.0f && command[1] == 5) {
                    datas = Float.valueOf(65280.0f);
                }
                command = Util.protocal.append(command, Util.protocal.octInt2ByteArray((int)(datas.floatValue() + 0.0f), 2));
                command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Util.crc.getCRC162Int(command, true), 2));
                try {
                    Object map2;
                    LockResult lockResult = (LockResult)session.getAttribute(cmdLock);
                    int sleepCount = 0;
                    while (lockResult.getFlag().booleanValue()) {
                        Thread.sleep(48L);
                        if (sleepCount++ <= 46) continue;
                        return;
                    }
                    if (Cache.deviceMap.containsKey(deviceCode)) {
                        map2 = new HashMap();
                        map2.put("askii", Util.binhexoct.bytesToHex(command));
                        map2.put("byte", Util.binhexoct.bytesToHex(command));
                        map2.put("direction", "1");
                        map2.put("time", new Date().getTime() + "");
                        MqttService.pubMessage(JSON.toJSONString((Object)map2), "/sys/debug/" + deviceCode);
                    }
                    map2 = lockResult;
                    synchronized (map2) {
                        lockResult = (LockResult)session.getAttribute(cmdLock);
                        lockResult.setFlag(true);
                        int i = repeatTimes;
                        while (i-- > 0) {
                            Util.mina.write(session, command);
                            lockResult.wait(timeOut.intValue());
                            if (lockResult.getFlag().booleanValue()) continue;
                        }
                    }
                    if (!lockResult.getFlag().booleanValue()) {
                        byte[] datab = (byte[])session.getAttribute(realData);
                        if (datab[0] == command[0] && datab[1] == command[1]) {
                            final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                            int rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(datab, 4, 5));
                            if (datab[1] == 5 && rh == 65280) {
                                rh = 1;
                            }
                            list.add(new IotSensorInfo(sensorDeviceId + "", portId, Float.valueOf((float)rh + 0.0f), deviceCode));
                            MinaServer.threadPool.execute(new Runnable(){

                                @Override
                                public void run() {
                                    String body = Util.json.object2Json(list);
                                    String url = Constants.URL.SENSORS_DATA;
                                    HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                                }
                            });
                        }
                    } else {
                        lockResult.setFlag(false);
                    }
                }
                catch (Exception e) {
                    if (!ObjectUtil.isNotEmpty(session).booleanValue()) break block21;
                    session.close(true);
                }
            }
        }
    }

    @Override
    public void handbert(IoSession session) {
        try {
            if (session.containsAttribute(nodeSensorsData)) {
                IotNodeInfoBO nodeBO = (IotNodeInfoBO)session.getAttribute(nodeSensorsData);
                long t = 120000L;
                if (session.getLastReadTime() + t < new Date().getTime()) {
                    if (session.containsAttribute("deviceFlag")) {
                        Util.mina.writeStr(session, "connect time out,");
                        Util.mina.writeStr(session, "please reconnect platform!");
                    }
                    session.close(true);
                    return;
                }
            } else {
                session.close(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProtocalModbus() {
    }

    public ProtocalModbus(IotNodeInfoBO nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block55: {
            IoSession session = Cache.nodeIdsessionMap.get(this.nodeInfo.getDevice_code());
            try {
                if (ObjectUtil.isNotEmpty(session).booleanValue()) {
                    String deviceCode = this.nodeInfo.getDevice_code();
                    this.nodeInfo = (IotNodeInfoBO)session.getAttribute(nodeSensorsData);
                    if (ObjectUtil.isNotEmpty(this.nodeInfo.getInfos()).booleanValue() && this.nodeInfo.getInfos().contains("fcode")) {
                        List sensorConfigs = JSON.parseArray((String)this.nodeInfo.getInfos(), ModbusConfig.class);
                        for (ModbusConfig sensorConfig : sensorConfigs) {
                            Object map2;
                            byte[] command = new byte[]{1, 3};
                            command[0] = (byte)Integer.parseInt(sensorConfig.getAddress() + "");
                            command[1] = "01".equals(sensorConfig.getFcode()) ? 1 : ("04".equals(sensorConfig.getFcode()) ? 4 : ("02".equals(sensorConfig.getFcode()) ? 2 : 3));
                            command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Integer.parseInt(sensorConfig.getSaddr()), 2));
                            command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Integer.parseInt(sensorConfig.getLength()), 2));
                            command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Util.crc.getCRC162Int(command, true), 2));
                            LockResult lockResult = (LockResult)session.getAttribute(cmdLock);
                            int sleepCount = 0;
                            while (lockResult.getFlag().booleanValue()) {
                                Thread.sleep(100L);
                                if (sleepCount++ <= 20) continue;
                                return;
                            }
                            if (ObjectUtil.isNotEmpty(session.getAttribute("deviceFlag")).booleanValue()) continue;
                            if (Cache.deviceMap.containsKey(deviceCode)) {
                                map2 = new HashMap();
                                map2.put("ascii", Util.binhexoct.bytesToHex(command));
                                map2.put("byte", Util.binhexoct.bytesToHex(command));
                                map2.put("time", new Date().getTime() + "");
                                map2.put("direction", "1");
                                map2.put("time", new Date().getTime() + "");
                                MqttService.pubMessage(JSON.toJSONString((Object)map2), "/sys/debug/" + deviceCode);
                            }
                            map2 = lockResult;
                            synchronized (map2) {
                                lockResult = (LockResult)session.getAttribute(cmdLock);
                                lockResult.setFlag(true);
                                int i = repeatTimes;
                                while (i-- > 0) {
                                    Util.mina.write(session, command);
                                    lockResult.wait(timeOut.intValue());
                                    if (lockResult.getFlag().booleanValue()) continue;
                                }
                            }
                            if (!lockResult.getFlag().booleanValue()) {
                                byte[] data = (byte[])session.getAttribute(realData);
                                int saddr = Integer.parseInt(sensorConfig.getSaddr());
                                if (command[0] == data[0] && command[1] == data[1] && (data[2] == (Integer.parseInt(sensorConfig.getLength()) - 1) / 8 + 1 || data[2] == Integer.parseInt(sensorConfig.getLength()) * 2)) {
                                    final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                                    List<IotSensorInfoBO> sensorList = ((IotNodeInfoBO)session.getAttribute(nodeSensorsData)).getIotSensorList();
                                    if (data[1] == 1 || data[1] == 2) {
                                        int returnDataLength = data[2];
                                        for (int k = 0; k < returnDataLength; ++k) {
                                            block12: for (int m = 0; m < 8; ++m) {
                                                for (int i = 0; i < sensorList.size(); ++i) {
                                                    String sensorDeviceId = sensorList.get(i).getSensor_device_id();
                                                    Integer sensorPortId = sensorList.get(i).getPort_id();
                                                    if (!sensorDeviceId.equals(data[0] + 0 + "") || saddr + k * 8 + m != sensorPortId) continue;
                                                    list.add(new IotSensorInfo(data[0] + 0 + "", (Integer)(saddr + k * 8 + m), data[3 + k] >> m & 1, deviceCode));
                                                    continue block12;
                                                }
                                            }
                                        }
                                    } else if (data[3] == 36) {
                                        StringBuffer stringBuffer = new StringBuffer();
                                        for (int i = 0; i < data.length; ++i) {
                                            stringBuffer.append((char)data[i]);
                                        }
                                        String msg = stringBuffer.toString();
                                        String gpsdata = msg.substring(3, 73);
                                        String[] subval = gpsdata.split(",");
                                        if (subval.length > 0) {
                                            String lon = subval[3];
                                            String lat = subval[5];
                                            Float latf = Float.valueOf((float)Integer.parseInt(lat.substring(0, 3)) + Float.parseFloat(lat.substring(3)) / 60.0f);
                                            Float lonf = Float.valueOf((float)Integer.parseInt(lon.substring(0, 2)) + Float.parseFloat(lon.substring(2)) / 60.0f);
                                            String lonlat = latf + "," + lonf;
                                            list.add(new IotSensorInfo(data[0] + "", (Integer)saddr, CoordinateTransformUtil.strwgs2bd(lonlat), deviceCode));
                                        }
                                    } else {
                                        for (int i = 0; i < sensorList.size(); ++i) {
                                            int rh;
                                            ModbusConfig modbus;
                                            if (ObjectUtil.isEmpty(sensorList.get(i).getInfos()).booleanValue()) {
                                                sensorList.get(i).setInfos("{}");
                                            }
                                            if (ObjectUtil.isEmpty(modbus = (ModbusConfig)JSON.parseObject((String)sensorList.get(i).getInfos(), ModbusConfig.class)).booleanValue()) {
                                                modbus = new ModbusConfig();
                                            }
                                            String sensorDeviceId = sensorList.get(i).getSensor_device_id();
                                            Integer sensorPortId = sensorList.get(i).getPort_id();
                                            if (Integer.parseInt(sensorDeviceId) != data[0]) continue;
                                            if ("float".equals(modbus.getType())) {
                                                if (sensorPortId < saddr || 3 + (sensorPortId - saddr) * 2 + 6 > data.length) continue;
                                                float rh2 = -1.0f;
                                                rh2 = "CDAB".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getFloat3412(data, 3 + (sensorPortId - saddr) * 2) : ("DCBA".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getFloat4321(data, 3 + (sensorPortId - saddr) * 2) : ("BADC".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getFloat2143(data, 3 + (sensorPortId - saddr) * 2) : Util.ByteArrayConveter.getFloat(data, 3 + (sensorPortId - saddr) * 2)));
                                                list.add(new IotSensorInfo(sensorDeviceId, sensorPortId, Float.valueOf(rh2 + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if ("int".equals(modbus.getType())) {
                                                if (sensorPortId < saddr || 3 + (sensorPortId - saddr) * 2 + 4 > data.length) continue;
                                                Integer start = 3 + (sensorPortId - saddr) * 2;
                                                rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, start, start + 1));
                                                if (rh > Short.MAX_VALUE) {
                                                    rh -= 65536;
                                                }
                                                list.add(new IotSensorInfo(sensorDeviceId, sensorPortId, Float.valueOf((float)rh + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if ("uint32".equals(modbus.getType())) {
                                                if (sensorPortId < saddr || 3 + (sensorPortId - saddr) * 2 + 6 > data.length) continue;
                                                Integer start = 3 + (sensorPortId - saddr) * 2;
                                                rh = 0;
                                                rh = "CDAB".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt3412(data, start) : ("DCBA".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt4321(data, start) : ("BADC".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt2143(data, start) : Util.ByteArrayConveter.getInt(data, start)));
                                                list.add(new IotSensorInfo(sensorDeviceId, sensorPortId, Float.valueOf((float)rh + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if ("int32".equals(modbus.getType())) {
                                                if (sensorPortId < saddr || 3 + (sensorPortId - saddr) * 2 + 6 > data.length) continue;
                                                Integer start = 3 + (sensorPortId - saddr) * 2;
                                                rh = 0;
                                                rh = "CDAB".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt3412(data, start) : ("DCBA".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt4321(data, start) : ("BADC".equals(modbus.getOrder()) ? Util.ByteArrayConveter.getInt2143(data, start) : Util.ByteArrayConveter.getInt(data, start)));
                                                if (rh > Integer.MAX_VALUE) {
                                                    long srh = (long)rh - 0x100000000L;
                                                    rh = (int)srh;
                                                }
                                                list.add(new IotSensorInfo(sensorDeviceId, sensorPortId, Float.valueOf((float)rh + 0.0f), deviceCode));
                                                continue;
                                            }
                                            if (sensorPortId < saddr || 3 + (sensorPortId - saddr) * 2 + 4 > data.length) continue;
                                            Integer start = 3 + (sensorPortId - saddr) * 2;
                                            rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, start, start + 1));
                                            list.add(new IotSensorInfo(sensorDeviceId, sensorPortId, Float.valueOf((float)rh + 0.0f), deviceCode));
                                        }
                                    }
                                    MinaServer.threadPool.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            String body = Util.json.object2Json(list);
                                            String url = Constants.URL.SENSORS_DATA;
                                            HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                                        }
                                    });
                                }
                            } else {
                                lockResult.setFlag(false);
                            }
                            Thread.sleep(120L);
                        }
                        break block55;
                    }
                    List<IotSensorInfoBO> iotSensorInfos = this.nodeInfo.getIotSensorList();
                    if (ObjectUtil.isEmpty(iotSensorInfos).booleanValue()) break block55;
                    for (IotSensorInfoBO obj : iotSensorInfos) {
                        Object map3;
                        ModbusConfig sensorConfig = (ModbusConfig)JSON.parseObject((String)obj.getInfos(), ModbusConfig.class);
                        if (ObjectUtil.isEmpty(sensorConfig).booleanValue()) {
                            sensorConfig = new ModbusConfig();
                        }
                        byte[] command = new byte[]{1, 3};
                        if (ObjectUtil.isEmpty(obj.getSensor_device_id()).booleanValue()) {
                            return;
                        }
                        command[0] = (byte)Integer.parseInt(obj.getSensor_device_id() + "");
                        command[1] = "01".equals(sensorConfig.getFcode()) ? 1 : ("02".equals(sensorConfig.getFcode()) ? 2 : ("04".equals(sensorConfig.getFcode()) ? 4 : ("05".equals(sensorConfig.getFcode()) ? 1 : ("06".equals(sensorConfig.getFcode()) ? 3 : 3))));
                        command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(obj.getPort_id(), 2));
                        command = "float".equals(sensorConfig.getType()) || "uint32".equals(sensorConfig.getType()) || "int32".equals(sensorConfig.getType()) ? Util.protocal.append(command, (byte)0, (byte)2) : Util.protocal.append(command, (byte)0, (byte)1);
                        command = Util.protocal.append(command, Util.protocal.octInt2ByteArray(Util.crc.getCRC162Int(command, true), 2));
                        LockResult lockResult = (LockResult)session.getAttribute(cmdLock);
                        int sleepCount = 0;
                        while (lockResult.getFlag().booleanValue()) {
                            Thread.sleep(100L);
                            if (sleepCount++ <= 20) continue;
                            return;
                        }
                        if (ObjectUtil.isNotEmpty(session.getAttribute("deviceFlag")).booleanValue()) continue;
                        if (Cache.deviceMap.containsKey(deviceCode)) {
                            map3 = new HashMap();
                            map3.put("askii", Util.binhexoct.bytesToHex(command));
                            map3.put("byte", Util.binhexoct.bytesToHex(command));
                            map3.put("direction", "1");
                            map3.put("time", new Date().getTime() + "");
                            MqttService.pubMessage(JSON.toJSONString((Object)map3), "/sys/debug/" + deviceCode);
                        }
                        map3 = lockResult;
                        synchronized (map3) {
                            lockResult = (LockResult)session.getAttribute(cmdLock);
                            lockResult.setFlag(true);
                            int i = repeatTimes;
                            while (i-- > 0) {
                                Util.mina.write(session, command);
                                lockResult.wait(timeOut.intValue());
                                if (lockResult.getFlag().booleanValue()) continue;
                            }
                        }
                        if (!lockResult.getFlag().booleanValue()) {
                            byte[] data = (byte[])session.getAttribute(realData);
                            if (data[0] == command[0] && data[1] == command[1]) {
                                final ArrayList<IotSensorInfo> list = new ArrayList<IotSensorInfo>();
                                float rh = -999.0f;
                                if ("float".equals(sensorConfig.getType()) && data[2] == 4) {
                                    rh = "CDAB".equals(sensorConfig.getOrder()) ? Util.ByteArrayConveter.getFloat3412(data, 3) : ("DCBA".equals(sensorConfig.getOrder()) ? Util.ByteArrayConveter.getFloat4321(data, 3) : ("BADC".equals(sensorConfig.getOrder()) ? Util.ByteArrayConveter.getFloat2143(data, 3) : Util.ByteArrayConveter.getFloat(data, 3)));
                                } else if ("int".equals(sensorConfig.getType()) && data[2] == 2) {
                                    Object[] objectArray = new Object[]{4};
                                    rh = Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 3, objectArray));
                                    if (rh > 32767.0f) {
                                        rh -= 65536.0f;
                                    }
                                } else if ("uint32".equals(sensorConfig.getType()) && data[2] == 4) {
                                    rh = "CDAB".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt3412(data, 3) : ("DCBA".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt4321(data, 3) : ("BADC".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt2143(data, 3) : (float)Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 3, 6))));
                                } else if ("int32".equals(sensorConfig.getType()) && data[2] == 4) {
                                    rh = "CDAB".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt3412(data, 3) : ("DCBA".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt4321(data, 3) : ("BADC".equals(sensorConfig.getOrder()) ? (float)Util.ByteArrayConveter.getInt2143(data, 3) : (float)Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 3, 6))));
                                    if (rh > 2.1474836E9f) {
                                        double srh = rh - 4.2949673E9f;
                                        rh = (float)srh;
                                    }
                                } else {
                                    rh = data[2] == 1 ? (float)(data[3] & 1) : (float)Integer.parseInt(Util.protocal.getOctFromHexBytes(data, 3, 4));
                                }
                                if (rh != -999.0f) {
                                    list.add(new IotSensorInfo(obj.getSensor_device_id(), obj.getPort_id(), Float.valueOf(rh + 0.0f), deviceCode));
                                }
                                MinaServer.threadPool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        String body = Util.json.object2Json(list);
                                        String url = Constants.URL.SENSORS_DATA;
                                        HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
                                    }
                                });
                            }
                        } else {
                            lockResult.setFlag(false);
                        }
                        Thread.sleep(120L);
                    }
                    break block55;
                }
                Timer timeTask = Cache.timerTaskMap.get(this.nodeInfo.getDevice_code());
                timeTask.cancel();
                timeTask = null;
                Cache.timerTaskMap.remove(this.nodeInfo.getDevice_code());
            }
            catch (Exception e) {
                this.cancel();
                if (!ObjectUtil.isNotEmpty(session).booleanValue()) break block55;
                session.close(true);
            }
        }
    }

    @Override
    public boolean match(IoSession session, byte[] data, String msg) {
        if (msg.contains("modbus_")) {
            return true;
        }
        return data != null && data.length > 3 && data[0] == -1 && data[1] == 0 && data[2] == -1;
    }

    @Override
    public void logout(IoSession session) {
        Timer timeTask = Cache.timerTaskMap.get(session.getAttribute("deviceId"));
        if (ObjectUtil.isNotEmpty(timeTask).booleanValue()) {
            timeTask.cancel();
            timeTask = null;
            Cache.timerTaskMap.remove(session.getAttribute("deviceId"));
        }
        IotNodeInfo iotNodeInfo = new IotNodeInfo();
        iotNodeInfo.setDevice_code(session.getAttribute("deviceId") + "");
        iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.offline);
        iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
        String body = Util.json.object2Json(iotNodeInfo);
        HttpServiceSender.doPut(Constants.URL.NODE_INFO, Config.IOT_USER_KEY, body);
    }
}

