/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.protocal.impl;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.bean.IotNodeInfo;
import com.lpro.iot.bean.IotNodeInfoBO;
import com.lpro.iot.bean.IotSensorInfo;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Cache;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.common.Constants;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.protocal.Iprotocal;
import com.lpro.iot.utils.CoordinateTransformUtil;
import com.lpro.iot.utils.HttpServiceSender;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.mina.core.session.IoSession;

public class ProtocalMing
implements Iprotocal {
    @Override
    public void loginProtocal(IoSession session, byte[] data, String msg, ReturnObj obj) {
        String deviceCode = null;
        if (obj == null) {
            if (msg.length() > 60) {
                return;
            }
            if (!"S".equalsIgnoreCase(msg.substring(0, 1)) || !"E".equalsIgnoreCase(msg.substring(msg.length() - 1, msg.length()))) {
                return;
            }
            deviceCode = msg.substring(1, msg.length() - 2);
            obj = Util.NodeDevice.login(deviceCode);
        } else {
            deviceCode = msg;
        }
        if (obj.getStatus() == Code.ResponseCode.OK + 0) {
            session.setAttribute("deviceId", deviceCode);
            session.setAttribute("nodeINfo", obj.getData());
            session.setAttribute("dataCache", "");
            session.setAttribute("ProtocolCategory", this.getClass().getSimpleName());
            if (Cache.nodeIdsessionMap.containsKey(deviceCode)) {
                Cache.nodeIdsessionMap.get(deviceCode).removeAttribute("deviceId");
                Cache.nodeIdsessionMap.get(deviceCode).close(true);
            }
            Cache.nodeIdsessionMap.put(deviceCode, session);
            Util.mina.writeStr(session, "loginok");
        }
    }

    @Override
    public void analysisData(IoSession session, byte[] data, String msg) {
        Object deviceCode = session.getAttribute("deviceId");
        String dataCache = (String)session.getAttribute("dataCache");
        if (ObjectUtil.isNotEmpty(dataCache).booleanValue()) {
            msg = dataCache + msg;
            session.setAttribute("dataCache", "");
        }
        if (Cache.deviceMap.containsKey(deviceCode)) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("askii", msg);
            map2.put("byte", Util.binhexoct.bytesToHex(data));
            MqttService.pubMessage(JSON.toJSONString(map2), "/sys/debug/" + deviceCode);
        }
        if ("S".equalsIgnoreCase(msg.substring(0, 1)) && "E".equalsIgnoreCase(msg.substring(msg.length() - 1, msg.length()))) {
            String[] subValue = msg.substring(1, msg.length() - 1).split(",");
            ArrayList<IotSensorInfo> listSensor = new ArrayList<IotSensorInfo>();
            for (int i = 0; i < subValue.length; ++i) {
                String[] s;
                String[] tmp = subValue[i].split("\\*");
                if (tmp.length != 2 || (s = tmp[0].split(":")).length != 2) continue;
                IotSensorInfo sensorInfo = new IotSensorInfo();
                sensorInfo.setDevice_code(deviceCode.toString());
                sensorInfo.setSensor_device_id(s[0]);
                sensorInfo.setPort_id(Integer.parseInt(s[1]));
                if (tmp[1].contains("+")) {
                    sensorInfo.setStr_sdata(CoordinateTransformUtil.strwgs2bd(tmp[1].replace("+", ",")));
                } else {
                    Float sdata = Float.valueOf(tmp[1]);
                    sensorInfo.setSdata(sdata);
                    sensorInfo.setRequest_sdata(sdata);
                }
                listSensor.add(sensorInfo);
            }
            String url = Constants.URL.SENSORS_DATA;
            String body = Util.json.object2Json(listSensor);
            String[] reponse = HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
            ReturnObj re = (ReturnObj)Util.json.string2Object(reponse[1], ReturnObj.class);
            if (re.getStatus() == Code.DEVICE_STATUS.OFFLINE) {
                session.close(true);
            }
            Util.mina.writeStr(session, "rok");
        } else if ("S".equalsIgnoreCase(msg.substring(0, 1))) {
            session.setAttribute("dataCache", msg);
        }
    }

    @Override
    public void handbert(IoSession session) {
        try {
            if (session.containsAttribute("nodeINfo")) {
                IotNodeInfoBO nodeBO = (IotNodeInfoBO)session.getAttribute("nodeINfo");
                if (nodeBO.getFrequency() < 1) {
                    return;
                }
                if (session.getLastReadTime() + (long)((nodeBO.getFrequency() + 60) * 1000) < new Date().getTime()) {
                    session.close(true);
                    return;
                }
            } else {
                session.close(true);
            }
        }
        catch (Exception e) {
            session.close(true);
        }
    }

    @Override
    public void execServer(IoSession session, byte[] data, String msg) {
        String subStr = msg.split(":")[1];
        String[] commands = subStr.split(",");
        String type = commands[0];
        if ("control".equalsIgnoreCase(type)) {
            String nodeDeviceCode = commands[1];
            Integer sensorDeviceId = Integer.parseInt(commands[2]);
            Integer portId = Integer.parseInt(commands[3]);
            Float sdata = Float.valueOf(Float.parseFloat(commands[4]));
            String command = "S" + sensorDeviceId + ":" + portId + "*" + (int)(sdata.floatValue() + 0.0f) + "E";
            Util.mina.writeStr(Cache.nodeIdsessionMap.get(nodeDeviceCode), command);
        } else if ("param_write".equalsIgnoreCase(type)) {
            String nodeDeviceCode = commands[1];
            Integer sensorDeviceId = Integer.parseInt(commands[2]);
            Integer portId = Integer.parseInt(commands[3]);
            Float sdata = Float.valueOf(Float.parseFloat(commands[4]));
            String command = "S" + sensorDeviceId + ":" + portId + "*" + (int)(sdata.floatValue() + 0.0f) + "E";
            Util.mina.writeStr(Cache.nodeIdsessionMap.get(nodeDeviceCode), command);
        }
    }

    @Override
    public boolean match(IoSession session, byte[] data, String msg) {
        return false;
    }

    @Override
    public void logout(IoSession session) {
        IotNodeInfo iotNodeInfo = new IotNodeInfo();
        iotNodeInfo.setDevice_code(session.getAttribute("deviceId") + "");
        iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.offline);
        iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
        String body = Util.json.object2Json(iotNodeInfo);
        HttpServiceSender.doPut(Constants.URL.NODE_INFO, Config.IOT_USER_KEY, body);
    }
}

