/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.protocal.impl;

import com.alibaba.fastjson.JSON;
import com.lpro.iot.bean.IotNodeInfo;
import com.lpro.iot.bean.IotNodeInfoBO;
import com.lpro.iot.bean.IotSensorInfoBO;
import com.lpro.iot.bean.ReturnObj;
import com.lpro.iot.common.Cache;
import com.lpro.iot.common.Code;
import com.lpro.iot.common.Config;
import com.lpro.iot.common.Constants;
import com.lpro.iot.mqtt.MqttService;
import com.lpro.iot.protocal.Iprotocal;
import com.lpro.iot.utils.HttpServiceSender;
import com.lpro.iot.utils.ObjectUtil;
import com.lpro.iot.utils.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.mina.core.session.IoSession;

public class ProtocalHj212
implements Iprotocal {
    private static final String nodeSensorsData = "NODE_SENSORS_DATA";

    @Override
    public boolean match(IoSession session, byte[] data, String msg) {
        return msg.length() > 10 && "##".equals(msg.subSequence(0, 2));
    }

    @Override
    public void loginProtocal(IoSession session, byte[] data, String msg, ReturnObj obj) {
        String deviceCode = "";
        if (obj == null) {
            String[] cmds = msg.split("MN=");
            if (cmds.length > 1) {
                deviceCode = cmds[1].split(";")[0];
            }
            if (StringUtils.isBlank(deviceCode)) {
                return;
            }
            obj = Util.NodeDevice.login(deviceCode);
        } else {
            deviceCode = msg;
        }
        if (obj.getStatus() == Code.ResponseCode.OK + 0) {
            session.setAttribute("deviceId", deviceCode);
            session.setAttribute(nodeSensorsData, obj.getData());
            session.setAttribute("dataCache", "");
            session.setAttribute("ProtocolCategory", this.getClass().getSimpleName());
            Cache.nodeIdsessionMap.put(deviceCode, session);
            this.analysisData(session, data, msg);
        }
    }

    @Override
    public void analysisData(IoSession session, byte[] data, String msg) {
        block11: {
            Object deviceCode = session.getAttribute("deviceId");
            ArrayList<IotSensorInfoBO> senorList = new ArrayList<IotSensorInfoBO>();
            String dataCache = (String)session.getAttribute("dataCache");
            if (Cache.deviceMap.containsKey(deviceCode)) {
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("askii", msg);
                map2.put("byte", Util.binhexoct.bytesToHex(data));
                MqttService.pubMessage(JSON.toJSONString(map2), "/sys/debug/" + deviceCode);
            }
            if (ObjectUtil.isNotEmpty(dataCache).booleanValue()) {
                msg = dataCache + msg;
                session.setAttribute("dataCache", "");
            }
            try {
                String[] datas;
                String[] cmds = msg.split("&&");
                if (cmds.length < 3) {
                    session.setAttribute("dataCache", msg);
                    break block11;
                }
                if (cmds.length > 3) {
                    return;
                }
                Date date2 = new Date();
                for (String tmp : datas = cmds[1].split(";")) {
                    IotSensorInfoBO sensorInfo = new IotSensorInfoBO();
                    sensorInfo.setDevice_code(deviceCode.toString());
                    if (tmp.contains("DataTime")) {
                        String dateStr = tmp.split("=")[1];
                        date2 = dateStr.length() == 17 ? Util.date.parse("yyyyMMddHHmmssSSS", dateStr) : Util.date.parse("yyyyMMddHHmmss", dateStr);
                        if (date2.getTime() < new Date().getTime() - 86400000L) {
                            date2 = new Date();
                            continue;
                        }
                        if (date2.getTime() <= new Date().getTime() + 60000L) continue;
                        date2 = new Date();
                        continue;
                    }
                    String[] val = tmp.contains(",") ? tmp.split(",")[0].split("=") : tmp.split("=");
                    sensorInfo.setSensor_device_id(val[0]);
                    sensorInfo.setPort_id(0);
                    try {
                        sensorInfo.setSdata(Float.valueOf(Float.parseFloat(val[1])));
                    }
                    catch (Exception e) {
                        continue;
                    }
                    sensorInfo.setMtime(date2);
                    senorList.add(sensorInfo);
                }
                String body = Util.json.object2Json(senorList);
                String url = Constants.URL.SENSORS_DATA;
                HttpServiceSender.doPut(url, Config.IOT_USER_KEY, body);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void handbert(IoSession session) {
        if (session.containsAttribute(nodeSensorsData)) {
            IotNodeInfoBO nodeBO = (IotNodeInfoBO)session.getAttribute(nodeSensorsData);
            if (nodeBO.getFrequency() < 1) {
                return;
            }
            if (session.getLastReadTime() + (long)((nodeBO.getFrequency() + 30) * 1000) < new Date().getTime()) {
                session.close(true);
                return;
            }
        } else {
            session.close(true);
        }
    }

    @Override
    public void execServer(IoSession session, byte[] data, String msg) {
    }

    @Override
    public void logout(IoSession session) {
        IotNodeInfo iotNodeInfo = new IotNodeInfo();
        iotNodeInfo.setDevice_code(session.getAttribute("deviceId") + "");
        iotNodeInfo.setIot_node_status(Code.IOT_NODE_STATUS.offline);
        iotNodeInfo.setLpmKey(Config.IOT_LPM_KEY);
        String body = Util.json.object2Json(iotNodeInfo);
        HttpServiceSender.doPut(Constants.URL.NODE_INFO, Config.IOT_USER_KEY, body);
    }
}

