/*
 * Decompiled with CFR 0.152.
 */
package com.lpro.iot.mqtt;

import com.lpro.iot.common.Config;
import com.lpro.iot.mqtt.MessageCallback;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttService {
    public static final String HOST = Config.IOT_MQTT_HOST;
    public static final String TOPIC = Config.IOT_MQTT_TOPIC;
    private static final String clientid = Config.IOT_MQTT_CLIENTID;
    private static final String userName = Config.IOT_MQTT_USERNAME;
    private static final String passWord = Config.IOT_MQTT_PASSWORD;
    public static Logger LOGGER = LoggerFactory.getLogger(MqttService.class);
    public static MqttClient client;

    public MqttService() throws MqttException {
        client = new MqttClient(HOST, clientid, (MqttClientPersistence)new MemoryPersistence());
        MqttService.connect();
    }

    public static void connect() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        options.setUserName(userName);
        options.setPassword(passWord.toCharArray());
        options.setConnectionTimeout(10);
        options.setKeepAliveInterval(20);
        options.setAutomaticReconnect(true);
        options.setCleanSession(true);
        try {
            client.setCallback((MqttCallback)new MessageCallback());
            client.connect(options);
            LOGGER.info("mqtt server connect success ;");
        }
        catch (Exception e) {
            LOGGER.error("Error:" + e.getLocalizedMessage() + "\uff0c\u8bf7\u68c0\u67e5EMQX\u662f\u5426\u6b63\u5e38\u542f\u52a8\uff01");
        }
    }

    public static void subscribe() {
        try {
            String[] topic1 = TOPIC.split(",");
            int[] Qos = new int[topic1.length];
            for (int i = 0; i < Qos.length; ++i) {
                Qos[i] = 1;
            }
            client.subscribe(topic1, Qos);
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage());
        }
    }

    public static void pubMessage(byte[] message, String topic) {
        MqttMessage mess = new MqttMessage();
        mess.setQos(1);
        mess.setRetained(false);
        mess.setPayload(message);
        try {
            client.publish(topic, mess);
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage());
        }
    }

    public static void pubMessage(String message, String topic) {
        MqttMessage mess = new MqttMessage();
        mess.setQos(1);
        mess.setRetained(false);
        mess.setPayload(message.getBytes());
        try {
            client.publish(topic, mess);
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage());
        }
    }
}

