/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.NIOHandler;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;

public class SocketTimeoutAuditor
extends SIPStackTimerTask {
    private static StackLogger logger = CommonLogger.getLogger(SocketTimeoutAuditor.class);
    long nioSocketMaxIdleTime;
    private NIOHandler nioHandler;

    public SocketTimeoutAuditor(long nioSocketMaxIdleTime, NIOHandler nioHandler) {
        this.nioSocketMaxIdleTime = nioSocketMaxIdleTime;
        this.nioHandler = nioHandler;
    }

    @Override
    public Object getThreadHash() {
        return null;
    }

    @Override
    public void runTask() {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("keys to check for inactivity removal " + this.nioHandler.channelMap.keySet());
            }
            Iterator<Map.Entry<SocketChannel, NioTcpMessageChannel>> entriesIterator = this.nioHandler.channelMap.entrySet().iterator();
            while (entriesIterator.hasNext()) {
                Map.Entry<SocketChannel, NioTcpMessageChannel> entry = entriesIterator.next();
                SocketChannel socketChannel = entry.getKey();
                NioTcpMessageChannel messageChannel = entry.getValue();
                if (System.currentTimeMillis() - messageChannel.getLastActivityTimestamp() > this.nioSocketMaxIdleTime) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Will remove socket " + messageChannel.key + " lastActivity=" + messageChannel.getLastActivityTimestamp() + " current= " + System.currentTimeMillis() + " socketChannel = " + socketChannel);
                    }
                    messageChannel.close();
                    entriesIterator = this.nioHandler.channelMap.entrySet().iterator();
                    continue;
                }
                if (!logger.isLoggingEnabled(32)) continue;
                logger.logDebug("don't remove socket " + messageChannel.key + " as lastActivity=" + messageChannel.getLastActivityTimestamp() + " and current= " + System.currentTimeMillis() + " socketChannel = " + socketChannel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

